/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import com.google.common.base.Charsets;
import haveno.core.alert.PrivateNotificationManager;
import haveno.core.locale.Res;
import haveno.core.offer.Offer;
import haveno.core.trade.Trade;
import haveno.core.user.Preferences;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.main.overlays.editor.PeerInfoWithTagEditor;
import haveno.desktop.util.DisplayUtils;
import haveno.network.p2p.NodeAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerInfoIcon
extends Group {
    private static final Logger log = LoggerFactory.getLogger(PeerInfoIcon.class);
    protected Preferences preferences;
    protected final String fullAddress;
    protected String tooltipText;
    protected Label tagLabel;
    private Label numTradesLabel;
    protected Pane tagPane;
    protected Pane numTradesPane;
    protected int numTrades = 0;
    private final StringProperty tag;

    public PeerInfoIcon(NodeAddress nodeAddress, Preferences preferences) {
        this.preferences = preferences;
        this.fullAddress = nodeAddress != null ? nodeAddress.getFullAddress() : "";
        this.tag = new SimpleStringProperty("");
    }

    protected void createAvatar(Color ringColor) {
        double scaleFactor = this.getScaleFactor();
        double outerSize = 26.0 * scaleFactor;
        Canvas outerBackground = new Canvas(outerSize, outerSize);
        GraphicsContext outerBackgroundGc = outerBackground.getGraphicsContext2D();
        outerBackgroundGc.setFill((Paint)ringColor);
        outerBackgroundGc.fillOval(0.0, 0.0, outerSize, outerSize);
        outerBackground.setLayoutY(1.0 * scaleFactor);
        int maxIndices = 15;
        int intValue = 0;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] bytes = md.digest(this.fullAddress.getBytes(Charsets.UTF_8));
            intValue = Math.abs((bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            log.error(e.toString());
        }
        int index = intValue % maxIndices + 1;
        double saturation = (double)(intValue % 1000) / 1000.0;
        int red = (intValue >> 8) % 256;
        int green = (intValue >> 16) % 256;
        int blue = (intValue >> 24) % 256;
        Color innerColor = Color.rgb((int)red, (int)green, (int)blue);
        innerColor = innerColor.deriveColor(1.0, saturation, 0.8, 1.0);
        double innerSize = scaleFactor * 22.0;
        Canvas innerBackground = new Canvas(innerSize, innerSize);
        GraphicsContext innerBackgroundGc = innerBackground.getGraphicsContext2D();
        innerBackgroundGc.setFill((Paint)innerColor);
        innerBackgroundGc.fillOval(0.0, 0.0, innerSize, innerSize);
        innerBackground.setLayoutY(3.0 * scaleFactor);
        innerBackground.setLayoutX(2.0 * scaleFactor);
        ImageView avatarImageView = new ImageView();
        avatarImageView.setId("avatar_" + index);
        avatarImageView.setLayoutX(0.0);
        avatarImageView.setLayoutY(1.0 * scaleFactor);
        avatarImageView.setFitHeight(scaleFactor * 26.0);
        avatarImageView.setFitWidth(scaleFactor * 26.0);
        this.numTradesPane = new Pane();
        this.numTradesPane.relocate(scaleFactor * 18.0, scaleFactor * 14.0);
        this.numTradesPane.setMouseTransparent(true);
        ImageView numTradesCircle = new ImageView();
        numTradesCircle.setId("image-green_circle_solid");
        this.numTradesLabel = new AutoTooltipLabel();
        this.numTradesLabel.relocate(scaleFactor * 5.0, scaleFactor * 1.0);
        this.numTradesLabel.setId("ident-num-label");
        this.numTradesPane.getChildren().addAll((Object[])new Node[]{numTradesCircle, this.numTradesLabel});
        this.tagPane = new Pane();
        this.tagPane.relocate((double)Math.round(scaleFactor * 18.0), scaleFactor * -2.0);
        this.tagPane.setMouseTransparent(true);
        ImageView tagCircle = new ImageView();
        tagCircle.setId("image-blue_circle_solid");
        this.tagLabel = new AutoTooltipLabel();
        this.tagLabel.relocate((double)Math.round(scaleFactor * 5.0), scaleFactor * 1.0);
        this.tagLabel.setId("ident-num-label");
        this.tagPane.getChildren().addAll((Object[])new Node[]{tagCircle, this.tagLabel});
        this.updatePeerInfoIcon();
        this.getChildren().addAll((Object[])new Node[]{outerBackground, innerBackground, avatarImageView, this.tagPane, this.numTradesPane});
    }

    protected void addMouseListener(int numTrades, PrivateNotificationManager privateNotificationManager, @Nullable Trade trade, Offer offer, Preferences preferences, boolean useDevPrivilegeKeys, boolean isFiatCurrency, long peersAccountAge, long peersSignAge, String peersAccountAgeInfo, String peersSignAgeInfo, String accountSigningState) {
        String accountAgeFormatted;
        String string = isFiatCurrency ? (peersAccountAge > -1L ? DisplayUtils.formatAccountAge(peersAccountAge) : Res.get((String)"peerInfo.unknownAge")) : (accountAgeFormatted = null);
        String signAgeFormatted = isFiatCurrency && peersSignAgeInfo != null ? (peersSignAge > -1L ? DisplayUtils.formatAccountAge(peersSignAge) : Res.get((String)"peerInfo.unknownAge")) : null;
        this.setOnMouseClicked(e -> {
            if (e.getButton().equals((Object)MouseButton.PRIMARY)) {
                new PeerInfoWithTagEditor(privateNotificationManager, trade, offer, preferences, useDevPrivilegeKeys).fullAddress(this.fullAddress).numTrades(numTrades).accountAge(accountAgeFormatted).signAge(signAgeFormatted).accountAgeInfo(peersAccountAgeInfo).signAgeInfo(peersSignAgeInfo).accountSigningState(accountSigningState).position(this.localToScene(new Point2D(0.0, 0.0))).onSave(newTag -> {
                    preferences.setTagForPeer(this.fullAddress, newTag);
                    this.tag.set(newTag);
                }).show();
            }
        });
    }

    protected double getScaleFactor() {
        return 1.0;
    }

    protected String getAccountAgeTooltip(Long accountAge) {
        return accountAge > -1L ? Res.get((String)"peerInfoIcon.tooltip.age", (Object[])new Object[]{DisplayUtils.formatAccountAge(accountAge)}) : Res.get((String)"peerInfoIcon.tooltip.unknownAge");
    }

    protected void updatePeerInfoIcon() {
        if (this.numTrades > 0) {
            this.numTradesLabel.setText(this.numTrades > 99 ? "*" : String.valueOf(this.numTrades));
            double scaleFactor = this.getScaleFactor();
            if (this.numTrades > 9 && this.numTrades < 100) {
                this.numTradesLabel.relocate(scaleFactor * 2.0, scaleFactor * 1.0);
            } else {
                this.numTradesLabel.relocate(scaleFactor * 5.0, scaleFactor * 1.0);
            }
        }
        this.numTradesPane.setVisible(this.numTrades > 0);
        this.refreshTag();
    }

    protected void refreshTag() {
        Map peerTagMap = this.preferences.getPeerTagMap();
        if (peerTagMap.containsKey(this.fullAddress)) {
            this.tag.set((Object)((String)peerTagMap.get(this.fullAddress)));
        }
        Tooltip.install((Node)this, (Tooltip)new Tooltip(!((String)this.tag.get()).isEmpty() ? Res.get((String)"peerInfoIcon.tooltip", (Object[])new Object[]{this.tooltipText, this.tag.get()}) : this.tooltipText));
        if (!((String)this.tag.get()).isEmpty()) {
            this.tagLabel.setText(((String)this.tag.get()).substring(0, 1));
        }
        this.tagPane.setVisible(!((String)this.tag.get()).isEmpty());
    }

    protected StringProperty tagProperty() {
        return this.tag;
    }
}

