/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import com.jfoenix.controls.JFXButton;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.View;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Pos;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuItem
extends JFXButton
implements Toggle {
    private static final Logger log = LoggerFactory.getLogger(MenuItem.class);
    private final Navigation navigation;
    private final ObjectProperty<ToggleGroup> toggleGroupProperty = new SimpleObjectProperty();
    private final Class<? extends View> viewClass;
    private final List<Class<? extends View>> baseNavPath;
    private final BooleanProperty selectedProperty = new SimpleBooleanProperty();
    private final ChangeListener<Toggle> listener;

    public MenuItem(Navigation navigation, ToggleGroup toggleGroup, String title, Class<? extends View> viewClass, List<Class<? extends View>> baseNavPath) {
        this.navigation = navigation;
        this.viewClass = viewClass;
        this.baseNavPath = baseNavPath;
        this.setLabelText(title);
        this.setPrefHeight(40.0);
        this.setPrefWidth(240.0);
        this.setAlignment(Pos.CENTER_LEFT);
        this.toggleGroupProperty.set((Object)toggleGroup);
        toggleGroup.getToggles().add((Object)this);
        this.setUserData(this.getUid());
        this.listener = (observable, oldValue, newValue) -> {
            Object userData = newValue.getUserData();
            String uid = this.getUid();
            if (newValue.isSelected() && userData != null && userData.equals(uid)) {
                this.getStyleClass().add((Object)"action-button");
            } else {
                this.getStyleClass().remove((Object)"action-button");
            }
        };
    }

    public ToggleGroup getToggleGroup() {
        return (ToggleGroup)this.toggleGroupProperty.get();
    }

    public void setToggleGroup(ToggleGroup toggleGroup) {
        this.toggleGroupProperty.set((Object)toggleGroup);
    }

    public ObjectProperty<ToggleGroup> toggleGroupProperty() {
        return this.toggleGroupProperty;
    }

    public boolean isSelected() {
        return this.selectedProperty.get();
    }

    public BooleanProperty selectedProperty() {
        return this.selectedProperty;
    }

    public void setSelected(boolean selected) {
        this.selectedProperty.set(selected);
    }

    public void activate() {
        this.setOnAction(event -> this.navigation.navigateTo(this.getNavPathClasses()));
        ((ToggleGroup)this.toggleGroupProperty.get()).selectedToggleProperty().addListener(this.listener);
    }

    public void deactivate() {
        this.setOnAction(null);
        ((ToggleGroup)this.toggleGroupProperty.get()).selectedToggleProperty().removeListener(this.listener);
    }

    public void setLabelText(String value) {
        this.setText(value.toUpperCase());
    }

    @NotNull
    private Class<? extends View>[] getNavPathClasses() {
        ArrayList<Class<? extends View>> list = new ArrayList<Class<? extends View>>(this.baseNavPath);
        list.add(this.viewClass);
        Class[] array = new Class[list.size()];
        list.toArray(array);
        return array;
    }

    private String getUid() {
        return this.viewClass.getName();
    }
}

