/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import com.jfoenix.adapters.ReflectionHelper;
import com.jfoenix.controls.base.IFXLabelFloatControl;
import com.jfoenix.controls.base.IFXStaticControl;
import com.jfoenix.skins.PromptLinesWrapper;
import com.jfoenix.skins.ValidationPane;
import java.lang.reflect.Field;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.TextFieldSkin;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;

public class JFXTextFieldSkinHavenoStyle<T extends TextField>
extends TextFieldSkin {
    private double inputLineExtension;
    private boolean invalid = true;
    private Text promptText;
    private Pane textPane = (Pane)this.getChildren().get(0);
    private Node textNode;
    private ObservableDoubleValue textRight;
    private DoubleProperty textTranslateX;
    private ValidationPane<T> errorContainer;
    private PromptLinesWrapper<T> linesWrapper;

    public JFXTextFieldSkinHavenoStyle(T textField, double inputLineExtension) {
        super(textField);
        this.inputLineExtension = inputLineExtension;
        this.textNode = (Node)ReflectionHelper.getFieldContent(TextFieldSkin.class, (Object)((Object)this), (String)"textNode");
        this.textTranslateX = (DoubleProperty)ReflectionHelper.getFieldContent(TextFieldSkin.class, (Object)((Object)this), (String)"textTranslateX");
        this.textRight = (ObservableDoubleValue)ReflectionHelper.getFieldContent(TextFieldSkin.class, (Object)((Object)this), (String)"textRight");
        this.linesWrapper = new PromptLinesWrapper(textField, this.promptTextFillProperty(), (ObservableValue)textField.textProperty(), (ObservableValue)textField.promptTextProperty(), () -> this.promptText);
        this.linesWrapper.init(() -> this.createPromptNode(), new Node[]{this.textPane});
        ReflectionHelper.setFieldContent(TextFieldSkin.class, (Object)((Object)this), (String)"usePromptText", (Object)this.linesWrapper.usePromptText);
        this.errorContainer = new ValidationPane(textField);
        this.getChildren().addAll((Object[])new Node[]{this.linesWrapper.line, this.linesWrapper.focusedLine, this.linesWrapper.promptContainer, this.errorContainer});
        this.registerChangeListener((ObservableValue)textField.disableProperty(), obs -> this.linesWrapper.updateDisabled());
        this.registerChangeListener((ObservableValue)((IFXLabelFloatControl)textField).focusColorProperty(), obs -> this.linesWrapper.updateFocusColor());
        this.registerChangeListener((ObservableValue)((IFXLabelFloatControl)textField).unFocusColorProperty(), obs -> this.linesWrapper.updateUnfocusColor());
        this.registerChangeListener((ObservableValue)((IFXStaticControl)textField).disableAnimationProperty(), obs -> this.errorContainer.updateClip());
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        double height = ((TextField)this.getSkinnable()).getHeight();
        double width = ((TextField)this.getSkinnable()).getWidth() + this.inputLineExtension;
        double paddingLeft = ((TextField)this.getSkinnable()).getPadding().getLeft();
        this.linesWrapper.layoutLines(x, y, width, h, height, Math.floor(h));
        this.errorContainer.layoutPane(x - paddingLeft, height + this.linesWrapper.focusedLine.getHeight(), width, h);
        if (((TextField)this.getSkinnable()).getWidth() > 0.0) {
            this.updateTextPos();
        }
        this.linesWrapper.updateLabelFloatLayout();
        if (this.invalid) {
            this.invalid = false;
            this.errorContainer.invalid(w);
            this.linesWrapper.invalid();
        }
    }

    private void updateTextPos() {
        double textWidth = this.textNode.getLayoutBounds().getWidth();
        double promptWidth = this.promptText == null ? 0.0 : this.promptText.getLayoutBounds().getWidth();
        switch (((TextField)this.getSkinnable()).getAlignment().getHpos()) {
            case CENTER: {
                this.linesWrapper.promptTextScale.setPivotX(promptWidth / 2.0);
                double midPoint = this.textRight.get() / 2.0;
                double newX = midPoint - textWidth / 2.0;
                if (!(newX + textWidth <= this.textRight.get())) break;
                this.textTranslateX.set(newX);
                break;
            }
            case LEFT: {
                this.linesWrapper.promptTextScale.setPivotX(0.0);
                break;
            }
            case RIGHT: {
                this.linesWrapper.promptTextScale.setPivotX(promptWidth);
            }
        }
    }

    private void createPromptNode() {
        if (this.promptText != null || !this.linesWrapper.usePromptText.get()) {
            return;
        }
        this.promptText = new Text();
        this.promptText.setManaged(false);
        this.promptText.getStyleClass().add((Object)"text");
        this.promptText.visibleProperty().bind((ObservableValue)this.linesWrapper.usePromptText);
        this.promptText.fontProperty().bind((ObservableValue)((TextField)this.getSkinnable()).fontProperty());
        this.promptText.textProperty().bind((ObservableValue)((TextField)this.getSkinnable()).promptTextProperty());
        this.promptText.fillProperty().bind((ObservableValue)this.linesWrapper.animatedPromptTextFill);
        this.promptText.setLayoutX(1.0);
        this.promptText.getTransforms().add((Object)this.linesWrapper.promptTextScale);
        this.linesWrapper.promptContainer.getChildren().add((Object)this.promptText);
        if (((TextField)this.getSkinnable()).isFocused() && ((IFXLabelFloatControl)this.getSkinnable()).isLabelFloat()) {
            this.promptText.setTranslateY(-Math.floor(this.textPane.getHeight()));
            this.linesWrapper.promptTextScale.setX(0.85);
            this.linesWrapper.promptTextScale.setY(0.85);
        }
        try {
            Field field = ReflectionHelper.getField(TextFieldSkin.class, (String)"promptNode");
            Object oldValue = field.get((Object)this);
            if (oldValue != null) {
                this.textPane.getChildren().remove(oldValue);
            }
            field.set((Object)this, this.promptText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

