/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import com.jfoenix.adapters.ReflectionHelper;
import com.jfoenix.controls.JFXTextArea;
import com.jfoenix.skins.PromptLinesWrapper;
import com.jfoenix.skins.ValidationPane;
import java.lang.reflect.Field;
import java.util.Arrays;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.skin.TextAreaSkin;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;

public class JFXTextAreaSkinHavenoStyle
extends TextAreaSkin {
    private boolean invalid = true;
    private ScrollPane scrollPane = (ScrollPane)this.getChildren().get(0);
    private Text promptText;
    private ValidationPane<JFXTextArea> errorContainer;
    private PromptLinesWrapper<JFXTextArea> linesWrapper;

    public JFXTextAreaSkinHavenoStyle(JFXTextArea textArea) {
        super((TextArea)textArea);
        textArea.setWrapText(true);
        this.linesWrapper = new PromptLinesWrapper((Control)textArea, this.promptTextFillProperty(), (ObservableValue)textArea.textProperty(), (ObservableValue)textArea.promptTextProperty(), () -> this.promptText);
        this.linesWrapper.init(() -> this.createPromptNode(), new Node[]{this.scrollPane});
        this.errorContainer = new ValidationPane((Region)textArea);
        this.getChildren().addAll((Object[])new Node[]{this.linesWrapper.line, this.linesWrapper.focusedLine, this.linesWrapper.promptContainer, this.errorContainer});
        this.registerChangeListener((ObservableValue)textArea.disableProperty(), obs -> this.linesWrapper.updateDisabled());
        this.registerChangeListener((ObservableValue)textArea.focusColorProperty(), obs -> this.linesWrapper.updateFocusColor());
        this.registerChangeListener((ObservableValue)textArea.unFocusColorProperty(), obs -> this.linesWrapper.updateUnfocusColor());
        this.registerChangeListener((ObservableValue)textArea.disableAnimationProperty(), obs -> this.errorContainer.updateClip());
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        double height = ((TextArea)this.getSkinnable()).getHeight();
        double width = ((TextArea)this.getSkinnable()).getWidth();
        this.linesWrapper.layoutLines(x - 2.0, y - 2.0, width, h, height, this.promptText == null ? 0.0 : this.promptText.getLayoutBounds().getHeight() + 3.0);
        this.errorContainer.layoutPane(x, height + this.linesWrapper.focusedLine.getHeight(), width, h);
        this.linesWrapper.updateLabelFloatLayout();
        if (this.invalid) {
            this.invalid = false;
            Region viewPort = (Region)this.scrollPane.getChildrenUnmodifiable().get(0);
            viewPort.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
            viewPort.applyCss();
            this.errorContainer.invalid(w);
            this.linesWrapper.invalid();
        }
    }

    private void createPromptNode() {
        if (this.promptText != null || !this.linesWrapper.usePromptText.get()) {
            return;
        }
        this.promptText = new Text();
        this.promptText.setManaged(false);
        this.promptText.getStyleClass().add((Object)"text");
        this.promptText.visibleProperty().bind((ObservableValue)this.linesWrapper.usePromptText);
        this.promptText.fontProperty().bind((ObservableValue)((TextArea)this.getSkinnable()).fontProperty());
        this.promptText.textProperty().bind((ObservableValue)((TextArea)this.getSkinnable()).promptTextProperty());
        this.promptText.fillProperty().bind((ObservableValue)this.linesWrapper.animatedPromptTextFill);
        this.promptText.getTransforms().add((Object)this.linesWrapper.promptTextScale);
        this.linesWrapper.promptContainer.getChildren().add((Object)this.promptText);
        if (((TextArea)this.getSkinnable()).isFocused() && ((JFXTextArea)this.getSkinnable()).isLabelFloat()) {
            this.promptText.setTranslateY(-Math.floor(this.scrollPane.getHeight()));
            this.linesWrapper.promptTextScale.setX(0.85);
            this.linesWrapper.promptTextScale.setY(0.85);
        }
        try {
            Field field = ReflectionHelper.getField(TextAreaSkin.class, (String)"promptNode");
            Object oldValue = field.get((Object)this);
            if (oldValue != null) {
                this.removeHighlight(Arrays.asList((Node)oldValue));
            }
            field.set((Object)this, this.promptText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

