/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import com.jfoenix.controls.JFXTextField;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.JFXTextFieldSkinHavenoStyle;
import haveno.desktop.util.GUIUtil;
import haveno.desktop.util.validation.JFXInputValidator;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;

public class InputTextField
extends JFXTextField {
    private final ObjectProperty<InputValidator.ValidationResult> validationResult = new SimpleObjectProperty((Object)new InputValidator.ValidationResult(true));
    private final JFXInputValidator jfxValidationWrapper = new JFXInputValidator();
    private double inputLineExtension = 0.0;
    private InputValidator validator;
    private String errorMessage = null;

    public InputValidator getValidator() {
        return this.validator;
    }

    public void setValidator(InputValidator validator) {
        this.validator = validator;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public InputTextField() {
        GUIUtil.applyFilledStyle((TextField)this);
        this.getValidators().add((Object)this.jfxValidationWrapper);
        this.validationResult.addListener((ov, oldValue, newValue) -> {
            if (newValue != null) {
                this.jfxValidationWrapper.resetValidation();
                if (!newValue.isValid) {
                    if (!newValue.errorMessageEquals(oldValue)) {
                        this.validate();
                    }
                    if (this.errorMessage != null) {
                        this.jfxValidationWrapper.applyErrorMessage(this.errorMessage);
                    } else {
                        this.jfxValidationWrapper.applyErrorMessage((InputValidator.ValidationResult)newValue);
                    }
                }
                this.validate();
            }
        });
        this.textProperty().addListener((o, oldValue, newValue) -> this.refreshValidation());
        this.focusedProperty().addListener((o, oldValue, newValue) -> {
            if (this.validator != null) {
                if (!oldValue.booleanValue() && newValue.booleanValue()) {
                    this.validationResult.set((Object)new InputValidator.ValidationResult(true));
                } else {
                    this.validationResult.set((Object)this.validator.validate(this.getText()));
                }
            }
        });
    }

    public InputTextField(double inputLineExtension) {
        this();
        this.inputLineExtension = inputLineExtension;
    }

    public void resetValidation() {
        this.jfxValidationWrapper.resetValidation();
        String input = this.getText();
        if (input.isEmpty()) {
            this.validationResult.set((Object)new InputValidator.ValidationResult(true));
        } else {
            this.validationResult.set((Object)this.validator.validate(input));
        }
    }

    public void refreshValidation() {
        if (this.validator != null) {
            this.validationResult.set((Object)this.validator.validate(this.getText()));
        }
    }

    public void setInvalid(String message) {
        this.validationResult.set((Object)new InputValidator.ValidationResult(false, message));
    }

    public ObjectProperty<InputValidator.ValidationResult> validationResultProperty() {
        return this.validationResult;
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXTextFieldSkinHavenoStyle<InputTextField>(this, this.inputLineExtension);
    }
}

