/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import com.jfoenix.controls.JFXTextField;
import de.jensd.fx.fontawesome.AwesomeIcon;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import haveno.desktop.components.HavenoTextField;
import haveno.desktop.components.PopOverWrapper;
import haveno.desktop.components.controlsfx.control.PopOver;
import haveno.desktop.util.FormBuilder;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoTextField
extends AnchorPane {
    public static final Logger log = LoggerFactory.getLogger(InfoTextField.class);
    protected final JFXTextField textField;
    private final StringProperty text = new SimpleStringProperty();
    protected final Label infoIcon;
    private Label currentIcon;
    private PopOverWrapper popoverWrapper = new PopOverWrapper();
    private PopOver.ArrowLocation arrowLocation = PopOver.ArrowLocation.RIGHT_TOP;

    public InfoTextField() {
        this.textField = new HavenoTextField();
        this.textField.setLabelFloat(true);
        this.textField.getStyleClass().add((Object)"label-float");
        this.textField.setEditable(false);
        this.textField.textProperty().bind((ObservableValue)this.text);
        this.textField.setFocusTraversable(false);
        this.textField.setId("info-field");
        this.infoIcon = FormBuilder.getIcon(AwesomeIcon.INFO_SIGN);
        this.infoIcon.setLayoutY(7.0);
        this.infoIcon.getStyleClass().addAll((Object[])new String[]{"icon", "info"});
        AnchorPane.setRightAnchor((Node)this.infoIcon, (Double)7.0);
        AnchorPane.setRightAnchor((Node)this.textField, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.textField, (Double)0.0);
        this.hideIcons();
        this.getChildren().addAll((Object[])new Node[]{this.textField, this.infoIcon});
    }

    public void setContentForInfoPopOver(Node node) {
        this.currentIcon = this.infoIcon;
        this.hideIcons();
        this.setActionHandlers(node);
    }

    public void setContent(MaterialDesignIcon icon, String info, String style, double opacity) {
        this.hideIcons();
        this.currentIcon = new Label();
        Text textIcon = FormBuilder.getRegularIconForLabel((GlyphIcons)icon, this.currentIcon);
        this.setActionHandlers((Node)new Label(info));
        this.currentIcon.setLayoutY(5.0);
        textIcon.getStyleClass().addAll((Object[])new String[]{"icon", style});
        this.currentIcon.setOpacity(opacity);
        AnchorPane.setRightAnchor((Node)this.currentIcon, (Double)7.0);
        this.getChildren().add((Object)this.currentIcon);
    }

    private void hideIcons() {
        this.infoIcon.setManaged(false);
        this.infoIcon.setVisible(false);
    }

    private void setActionHandlers(Node node) {
        this.currentIcon.setManaged(true);
        this.currentIcon.setVisible(true);
        this.currentIcon.setOnMouseEntered(e -> this.popoverWrapper.showPopOver(() -> this.createPopOver(node)));
        this.currentIcon.setOnMouseExited(e -> this.popoverWrapper.hidePopOver());
    }

    private PopOver createPopOver(Node node) {
        node.getStyleClass().add((Object)"default-text");
        PopOver popover = new PopOver(node);
        if (this.currentIcon.getScene() != null) {
            popover.setDetachable(false);
            popover.setArrowLocation(this.arrowLocation);
            popover.setArrowIndent(5.0);
            popover.show((Node)this.currentIcon, -17.0);
        }
        return popover;
    }

    public void setText(String text) {
        this.text.set((Object)text);
    }

    public String getText() {
        return (String)this.text.get();
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public JFXTextField getTextField() {
        return this.textField;
    }
}

