/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import com.google.common.base.Preconditions;
import de.jensd.fx.fontawesome.AwesomeDude;
import de.jensd.fx.fontawesome.AwesomeIcon;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.PopOverWrapper;
import haveno.desktop.components.controlsfx.control.PopOver;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javax.annotation.Nullable;

public class InfoInputTextField
extends AnchorPane {
    private final StringProperty text = new SimpleStringProperty();
    private final InputTextField inputTextField;
    private final Label icon;
    private final PopOverWrapper popoverWrapper = new PopOverWrapper();
    @Nullable
    private Node node;

    public InfoInputTextField() {
        this(0.0);
    }

    public InfoInputTextField(double inputLineExtension) {
        this.inputTextField = new InputTextField(inputLineExtension);
        AnchorPane.setRightAnchor((Node)this.inputTextField, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.inputTextField, (Double)0.0);
        this.icon = new Label();
        this.icon.setLayoutY(3.0);
        AnchorPane.setLeftAnchor((Node)this.icon, (Double)7.0);
        this.icon.setOnMouseEntered(e -> {
            if (this.node != null) {
                this.popoverWrapper.showPopOver(() -> (PopOver)((Object)((Object)((Object)Preconditions.checkNotNull((Object)((Object)this.createPopOver()))))));
            }
        });
        this.icon.setOnMouseExited(e -> {
            if (this.node != null) {
                this.popoverWrapper.hidePopOver();
            }
        });
        this.hideIcon();
        this.getChildren().addAll((Object[])new Node[]{this.inputTextField, this.icon});
    }

    public void setContentForInfoPopOver(Node node) {
        this.setContentForPopOver(node, AwesomeIcon.INFO_SIGN);
    }

    public void setContentForWarningPopOver(Node node) {
        this.setContentForPopOver(node, AwesomeIcon.WARNING_SIGN, "warning");
    }

    public void setContentForPrivacyPopOver(Node node) {
        this.setContentForPopOver(node, AwesomeIcon.EYE_CLOSE);
    }

    public void setContentForPopOver(Node node, AwesomeIcon awesomeIcon) {
        this.setContentForPopOver(node, awesomeIcon, null);
    }

    public void setContentForPopOver(Node node, AwesomeIcon awesomeIcon, @Nullable String style) {
        this.node = node;
        AwesomeDude.setIcon((Label)this.icon, (AwesomeIcon)awesomeIcon);
        this.icon.getStyleClass().removeAll((Object[])new String[]{"icon", "info", "warning", style});
        this.icon.getStyleClass().addAll((Object[])new String[]{"icon", style == null ? "info" : style});
        this.icon.setManaged(true);
        this.icon.setVisible(true);
    }

    public void hideIcon() {
        this.icon.setManaged(false);
        this.icon.setVisible(false);
    }

    public void setIconsRightAligned() {
        AnchorPane.clearConstraints((Node)this.icon);
        AnchorPane.clearConstraints((Node)this.inputTextField);
        AnchorPane.setRightAnchor((Node)this.icon, (Double)7.0);
        AnchorPane.setLeftAnchor((Node)this.inputTextField, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.inputTextField, (Double)0.0);
    }

    public void setText(String text) {
        this.text.set((Object)text);
    }

    public String getText() {
        return (String)this.text.get();
    }

    public StringProperty textProperty() {
        return this.text;
    }

    private PopOver createPopOver() {
        if (this.node == null) {
            return null;
        }
        this.node.getStyleClass().add((Object)"default-text");
        PopOver popover = new PopOver(this.node);
        if (this.icon.getScene() != null) {
            popover.setDetachable(false);
            popover.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
            popover.setArrowIndent(5.0);
            popover.show((Node)this.icon, -17.0);
        }
        return popover;
    }

    public InputTextField getInputTextField() {
        return this.inputTextField;
    }
}

