/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import de.jensd.fx.fontawesome.AwesomeIcon;
import haveno.common.UserThread;
import haveno.core.locale.Res;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.util.FormBuilder;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.layout.GridPane;
import javafx.scene.text.TextFlow;

public class InfoDisplay
extends Parent {
    private final StringProperty text = new SimpleStringProperty();
    private final IntegerProperty rowIndex = new SimpleIntegerProperty(0);
    private final IntegerProperty columnIndex = new SimpleIntegerProperty(0);
    private final ObjectProperty<EventHandler<ActionEvent>> onAction = new SimpleObjectProperty();
    private final ObjectProperty<GridPane> gridPane = new SimpleObjectProperty();
    private boolean useReadMore;
    private final Label icon = FormBuilder.getIcon(AwesomeIcon.INFO_SIGN);
    private final TextFlow textFlow;
    private final Label label;
    private final Hyperlink link;

    public InfoDisplay() {
        this.icon.setId("non-clickable-icon");
        this.icon.visibleProperty().bind((ObservableValue)this.visibleProperty());
        GridPane.setValignment((Node)this.icon, (VPos)VPos.TOP);
        GridPane.setMargin((Node)this.icon, (Insets)new Insets(-2.0, 0.0, 0.0, 0.0));
        GridPane.setRowSpan((Node)this.icon, (Integer)2);
        this.label = new AutoTooltipLabel();
        this.label.textProperty().bind((ObservableValue)this.text);
        this.label.setTextOverrun(OverrunStyle.WORD_ELLIPSIS);
        this.label.setVisible(false);
        this.link = new Hyperlink(Res.get((String)"shared.readMore"));
        this.link.setPadding(new Insets(0.0, 0.0, 0.0, -2.0));
        AutoTooltipLabel testLabel = new AutoTooltipLabel();
        testLabel.textProperty().bind((ObservableValue)this.text);
        this.textFlow = new TextFlow();
        this.textFlow.visibleProperty().bind((ObservableValue)this.visibleProperty());
        this.textFlow.getChildren().addAll((Object[])new Node[]{testLabel});
        testLabel.widthProperty().addListener((ov, o, n) -> {
            this.useReadMore = (Double)n > this.textFlow.getWidth();
            this.link.setText(Res.get((String)(this.useReadMore ? "shared.readMore" : "shared.openHelp")));
            UserThread.execute(() -> this.textFlow.getChildren().setAll((Object[])new Node[]{this.label, this.link}));
        });
        final ChangeListener listener = (ov2, oldValue2, windowWidth) -> {
            if (this.label.prefWidthProperty().isBound()) {
                this.label.prefWidthProperty().unbind();
            }
            this.label.setPrefWidth((Double)windowWidth - this.localToScene(0.0, 0.0).getX() - 35.0);
        };
        this.link.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (InfoDisplay.this.useReadMore) {
                    InfoDisplay.this.label.setWrapText(true);
                    InfoDisplay.this.link.setText(Res.get((String)"shared.openHelp"));
                    InfoDisplay.this.getScene().getWindow().widthProperty().removeListener(listener);
                    if (InfoDisplay.this.label.prefWidthProperty().isBound()) {
                        InfoDisplay.this.label.prefWidthProperty().unbind();
                    }
                    InfoDisplay.this.label.prefWidthProperty().bind((ObservableValue)InfoDisplay.this.textFlow.widthProperty());
                    InfoDisplay.this.link.setVisited(false);
                    InfoDisplay.this.link.getStyleClass().add((Object)"hide-focus");
                    InfoDisplay.this.link.setOnAction((EventHandler)InfoDisplay.this.onAction.get());
                    InfoDisplay.this.getParent().layout();
                } else {
                    ((EventHandler)InfoDisplay.this.onAction.get()).handle((Event)actionEvent);
                }
            }
        });
        this.sceneProperty().addListener((ov, oldValue, newValue) -> {
            if (oldValue == null && newValue != null && newValue.getWindow() != null) {
                newValue.getWindow().widthProperty().addListener(listener);
                UserThread.execute(() -> {
                    this.label.setVisible(true);
                    this.label.prefWidthProperty().unbind();
                    this.label.setPrefWidth(newValue.getWindow().getWidth() - this.localToScene(0.0, 0.0).getX() - 35.0);
                });
            }
        });
    }

    public void setText(String text) {
        this.text.set((Object)text);
        UserThread.execute(() -> {
            if (this.getScene() != null) {
                this.label.setVisible(true);
                this.label.prefWidthProperty().unbind();
                this.label.setPrefWidth(this.getScene().getWindow().getWidth() - this.localToScene(0.0, 0.0).getX() - 35.0);
            }
        });
    }

    public void setGridPane(GridPane gridPane) {
        this.gridPane.set((Object)gridPane);
        gridPane.getChildren().addAll((Object[])new Node[]{this.icon, this.textFlow});
        GridPane.setColumnIndex((Node)this.icon, (Integer)this.columnIndex.get());
        GridPane.setColumnIndex((Node)this.textFlow, (Integer)(this.columnIndex.get() + 1));
        GridPane.setRowIndex((Node)this.icon, (Integer)this.rowIndex.get());
        GridPane.setRowIndex((Node)this.textFlow, (Integer)this.rowIndex.get());
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex.set(rowIndex);
        GridPane.setRowIndex((Node)this.icon, (Integer)rowIndex);
        GridPane.setRowIndex((Node)this.textFlow, (Integer)rowIndex);
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex.set(columnIndex);
        GridPane.setColumnIndex((Node)this.icon, (Integer)columnIndex);
        GridPane.setColumnIndex((Node)this.textFlow, (Integer)(columnIndex + 1));
    }

    public final void setOnAction(EventHandler<ActionEvent> eventHandler) {
        this.onAction.set(eventHandler);
    }

    public String getText() {
        return (String)this.text.get();
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public int getColumnIndex() {
        return this.columnIndex.get();
    }

    public IntegerProperty columnIndexProperty() {
        return this.columnIndex;
    }

    public int getRowIndex() {
        return this.rowIndex.get();
    }

    public IntegerProperty rowIndexProperty() {
        return this.rowIndex;
    }

    public EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onAction.get();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public GridPane getGridPane() {
        return (GridPane)this.gridPane.get();
    }

    public ObjectProperty<GridPane> gridPaneProperty() {
        return this.gridPane;
    }
}

