/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import de.jensd.fx.fontawesome.AwesomeIcon;
import de.jensd.fx.glyphs.GlyphIcons;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.PopOverWrapper;
import haveno.desktop.components.controlsfx.control.PopOver;
import haveno.desktop.util.FormBuilder;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;

public class InfoAutoTooltipLabel
extends AutoTooltipLabel {
    public static final int DEFAULT_WIDTH = 300;
    private Node textIcon;
    private PopOverWrapper popoverWrapper = new PopOverWrapper();
    private ContentDisplay contentDisplay;

    public InfoAutoTooltipLabel(String text, GlyphIcons icon, ContentDisplay contentDisplay, String info) {
        this(text, contentDisplay);
        this.setIcon(icon);
        this.positionAndActivateIcon(contentDisplay, info, 300.0);
    }

    public InfoAutoTooltipLabel(String text, AwesomeIcon icon, ContentDisplay contentDisplay, String info, double width) {
        super(text);
        this.setIcon(icon);
        this.positionAndActivateIcon(contentDisplay, info, width);
    }

    public InfoAutoTooltipLabel(String text, ContentDisplay contentDisplay) {
        super(text);
        this.contentDisplay = contentDisplay;
    }

    public void setIcon(GlyphIcons icon) {
        this.textIcon = FormBuilder.getIcon(icon);
    }

    public void setIcon(GlyphIcons icon, String info) {
        this.setIcon(icon);
        this.positionAndActivateIcon(this.contentDisplay, info, 300.0);
    }

    public void setIcon(AwesomeIcon icon) {
        this.textIcon = FormBuilder.getIcon(icon);
    }

    public void hideIcon() {
        this.textIcon = null;
        this.setGraphic(this.textIcon);
    }

    public void disableRolloverPopup() {
        this.textIcon.setOnMouseEntered(null);
        this.textIcon.setOnMouseExited(null);
    }

    private void positionAndActivateIcon(ContentDisplay contentDisplay, String info, double width) {
        this.textIcon.setOpacity(0.4);
        this.textIcon.getStyleClass().add((Object)"tooltip-icon");
        this.textIcon.setOnMouseEntered(e -> this.popoverWrapper.showPopOver(() -> this.createInfoPopOver(info, width)));
        this.textIcon.setOnMouseExited(e -> this.popoverWrapper.hidePopOver());
        this.setGraphic(this.textIcon);
        this.setContentDisplay(contentDisplay);
    }

    private PopOver createInfoPopOver(String info, double width) {
        Label helpLabel = new Label(info);
        helpLabel.setMaxWidth(width);
        helpLabel.setWrapText(true);
        helpLabel.setPadding(new Insets(10.0));
        return this.createInfoPopOver((Node)helpLabel);
    }

    private PopOver createInfoPopOver(Node node) {
        node.getStyleClass().add((Object)"default-text");
        PopOver infoPopover = new PopOver(node);
        if (this.textIcon.getScene() != null) {
            infoPopover.setDetachable(false);
            infoPopover.setArrowLocation(PopOver.ArrowLocation.LEFT_CENTER);
            infoPopover.show(this.textIcon, -10.0);
        }
        return infoPopover;
    }
}

