/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import de.jensd.fx.fontawesome.AwesomeDude;
import de.jensd.fx.fontawesome.AwesomeIcon;
import de.jensd.fx.glyphs.GlyphIcons;
import haveno.desktop.util.FormBuilder;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.text.Text;

public class HyperlinkWithIcon
extends Hyperlink {
    private Node icon;

    public HyperlinkWithIcon(String text) {
        this(text, AwesomeIcon.INFO_SIGN);
    }

    public HyperlinkWithIcon(String text, String fontSize) {
        this(text, AwesomeIcon.INFO_SIGN, fontSize);
    }

    public HyperlinkWithIcon(String text, AwesomeIcon awesomeIcon, String fontSize) {
        super(text);
        Label icon = new Label();
        AwesomeDude.setIcon((Label)icon, (AwesomeIcon)awesomeIcon, (String)fontSize);
        icon.setMinWidth(20.0);
        icon.setOpacity(0.7);
        icon.getStyleClass().addAll((Object[])new String[]{"hyperlink", "no-underline"});
        this.setPadding(new Insets(0.0));
        icon.setPadding(new Insets(0.0));
        this.setIcon((Node)icon);
    }

    public HyperlinkWithIcon(String text, AwesomeIcon awesomeIcon) {
        this(text, awesomeIcon, "1.231em");
    }

    public HyperlinkWithIcon(String text, GlyphIcons icon) {
        this(text, icon, null);
    }

    public HyperlinkWithIcon(String text, GlyphIcons icon, String style, String iconSize) {
        super(text);
        Text textIcon = FormBuilder.getIcon(icon, iconSize);
        textIcon.setOpacity(0.7);
        textIcon.getStyleClass().addAll((Object[])new String[]{"hyperlink", "no-underline"});
        if (style != null) {
            textIcon.getStyleClass().add((Object)style);
            this.getStyleClass().add((Object)style);
        }
        this.setPadding(new Insets(0.0));
        this.setIcon((Node)textIcon);
    }

    public HyperlinkWithIcon(String text, GlyphIcons icon, String style) {
        this(text, icon, style, "1.231em");
    }

    public void hideIcon() {
        this.setGraphic(null);
    }

    public void setIcon(Node icon) {
        this.icon = icon;
        this.setGraphic(icon);
        this.setContentDisplay(ContentDisplay.RIGHT);
        this.setGraphicTextGap(7.0);
    }

    public void clear() {
        this.setText("");
        this.setGraphic(null);
    }

    public Node getIcon() {
        return this.icon;
    }
}

