/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.desktop.components.InfoTextField;
import haveno.desktop.util.GUIUtil;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FundsTextField
extends InfoTextField {
    public static final Logger log = LoggerFactory.getLogger(FundsTextField.class);
    private final StringProperty fundsStructure = new SimpleStringProperty();

    public FundsTextField() {
        this.textField.textProperty().unbind();
        this.textField.textProperty().bind((ObservableValue)Bindings.concat((Object[])new Object[]{this.textProperty()}));
        Label copyLabel = new Label();
        copyLabel.setLayoutY(9.0);
        copyLabel.getStyleClass().addAll((Object[])new String[]{"icon", "highlight"});
        Tooltip.install((Node)copyLabel, (Tooltip)new Tooltip(Res.get((String)"shared.copyToClipboard")));
        copyLabel.setGraphic((Node)GUIUtil.getCopyIcon());
        copyLabel.setOnMouseClicked(e -> {
            String text = this.getText();
            if (text != null && text.length() > 0) {
                String[] strings = text.split(" ");
                String copyText = strings.length > 1 ? strings[0] : text;
                Utilities.copyToClipboard((String)copyText);
            }
        });
        AnchorPane.setRightAnchor((Node)copyLabel, (Double)30.0);
        AnchorPane.setRightAnchor((Node)this.infoIcon, (Double)62.0);
        AnchorPane.setRightAnchor((Node)this.textField, (Double)55.0);
        this.getChildren().add((Object)copyLabel);
    }

    public void setFundsStructure(String fundsStructure) {
        this.fundsStructure.set((Object)fundsStructure);
    }
}

