/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import com.jfoenix.controls.JFXTextField;
import de.jensd.fx.fontawesome.AwesomeDude;
import de.jensd.fx.fontawesome.AwesomeIcon;
import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.core.user.Preferences;
import haveno.desktop.util.GUIUtil;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javax.annotation.Nullable;

public class ExplorerAddressTextField
extends AnchorPane {
    private static Preferences preferences;
    private final TextField textField;
    private final Label copyLabel = new Label();
    private final Label missingAddressWarningIcon;

    public ExplorerAddressTextField() {
        this.copyLabel.setLayoutY(3.0);
        this.copyLabel.getStyleClass().addAll((Object[])new String[]{"icon", "highlight"});
        this.copyLabel.setTooltip(new Tooltip(Res.get((String)"explorerAddressTextField.copyToClipboard")));
        this.copyLabel.setGraphic((Node)GUIUtil.getCopyIcon());
        AnchorPane.setRightAnchor((Node)this.copyLabel, (Double)30.0);
        Tooltip tooltip = new Tooltip(Res.get((String)"explorerAddressTextField.blockExplorerIcon.tooltip"));
        this.missingAddressWarningIcon = new Label();
        this.missingAddressWarningIcon.getStyleClass().addAll((Object[])new String[]{"icon", "error-icon"});
        AwesomeDude.setIcon((Label)this.missingAddressWarningIcon, (AwesomeIcon)AwesomeIcon.WARNING_SIGN);
        this.missingAddressWarningIcon.setTooltip(new Tooltip(Res.get((String)"explorerAddressTextField.missingTx.warning.tooltip")));
        this.missingAddressWarningIcon.setMinWidth(20.0);
        AnchorPane.setRightAnchor((Node)this.missingAddressWarningIcon, (Double)52.0);
        AnchorPane.setTopAnchor((Node)this.missingAddressWarningIcon, (Double)4.0);
        this.missingAddressWarningIcon.setVisible(false);
        this.missingAddressWarningIcon.setManaged(false);
        this.textField = new JFXTextField();
        this.textField.setId("address-text-field");
        this.textField.setEditable(false);
        this.textField.setTooltip(tooltip);
        AnchorPane.setRightAnchor((Node)this.textField, (Double)80.0);
        AnchorPane.setLeftAnchor((Node)this.textField, (Double)0.0);
        this.textField.focusTraversableProperty().set(this.focusTraversableProperty().get());
        this.getChildren().addAll((Object[])new Node[]{this.textField, this.missingAddressWarningIcon, this.copyLabel});
    }

    public void setup(@Nullable String address) {
        if (address == null) {
            this.textField.setText(Res.get((String)"shared.na"));
            this.textField.setId("address-text-field-error");
            this.copyLabel.setVisible(false);
            this.copyLabel.setManaged(false);
            this.missingAddressWarningIcon.setVisible(true);
            this.missingAddressWarningIcon.setManaged(true);
            return;
        }
        this.textField.setText(address);
        this.copyLabel.setOnMouseClicked(e -> Utilities.copyToClipboard((String)address));
    }

    public void cleanup() {
        this.textField.setOnMouseClicked(null);
        this.copyLabel.setOnMouseClicked(null);
        this.textField.setText("");
    }

    public static void setPreferences(Preferences preferences) {
        ExplorerAddressTextField.preferences = preferences;
    }

    public TextField getTextField() {
        return this.textField;
    }
}

