/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import com.jfoenix.controls.JFXTextField;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.components.HavenoTextField;
import java.math.BigInteger;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javax.annotation.Nullable;

public class BalanceTextField
extends AnchorPane {
    private BigInteger targetAmount;
    private final JFXTextField textField;
    private final Effect fundedEffect = new DropShadow(BlurType.THREE_PASS_BOX, Color.GREEN, 4.0, 0.0, 0.0, 0.0);
    private final Effect notFundedEffect = new DropShadow(BlurType.THREE_PASS_BOX, Color.ORANGERED, 4.0, 0.0, 0.0, 0.0);
    private CoinFormatter formatter;
    @Nullable
    private BigInteger balance;

    public BalanceTextField(String label) {
        this.textField = new HavenoTextField();
        this.textField.setLabelFloat(true);
        this.textField.getStyleClass().add((Object)"label-float");
        this.textField.setPromptText(label);
        this.textField.setFocusTraversable(false);
        this.textField.setEditable(false);
        this.textField.setId("info-field");
        AnchorPane.setRightAnchor((Node)this.textField, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.textField, (Double)0.0);
        this.getChildren().addAll((Object[])new Node[]{this.textField});
    }

    public void setFormatter(CoinFormatter formatter) {
        this.formatter = formatter;
    }

    public void setBalance(BigInteger balance) {
        this.balance = balance;
        this.updateBalance(balance);
    }

    public void setTargetAmount(BigInteger targetAmount) {
        this.targetAmount = targetAmount;
        if (this.balance != null) {
            this.updateBalance(this.balance);
        }
    }

    private void updateBalance(BigInteger balance) {
        if (this.formatter != null) {
            this.textField.setText(HavenoUtils.formatXmr((BigInteger)balance, (boolean)true));
        }
    }
}

