/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.skins.JFXComboBoxListViewSkin;
import haveno.common.UserThread;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.apache.commons.lang3.StringUtils;

public class AutocompleteComboBox<T>
extends JFXComboBox<T> {
    private List<? extends T> list;
    private List<? extends T> extendedList;
    private List<T> matchingList;
    private JFXComboBoxListViewSkin<T> comboBoxListViewSkin;
    private boolean selectAllShortcut = false;
    private T lastCommittedValue;

    public AutocompleteComboBox() {
        this(FXCollections.observableArrayList());
    }

    private AutocompleteComboBox(ObservableList<T> items) {
        super(items);
        this.setEditable(true);
        this.clearOnFocus();
        this.setEmptySkinToGetMoreControlOverListView();
        this.fixSpaceKey();
        this.setAutocompleteItems((List<? extends T>)items);
        this.reactToQueryChanges();
        this.valueProperty().addListener((obs, oldVal, newVal) -> {
            if (newVal != null) {
                this.lastCommittedValue = newVal;
            }
        });
        this.getEditor().focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
            if (!isNowFocused.booleanValue()) {
                String input = this.getEditor().getText();
                Object matched = this.getConverter().fromString(input);
                boolean matchFound = this.getItems().stream().anyMatch(item -> item.equals(matched));
                if (!matchFound) {
                    UserThread.execute(() -> {
                        this.getSelectionModel().select(this.lastCommittedValue);
                        this.getEditor().setText(this.asString(this.lastCommittedValue));
                    });
                }
            }
        });
    }

    public void setAutocompleteItems(List<? extends T> items, List<? extends T> allItems) {
        this.list = items;
        this.extendedList = allItems;
        this.matchingList = new ArrayList<T>(this.list);
        this.setValue(null);
        this.getSelectionModel().clearSelection();
        this.setItems(FXCollections.observableList(this.matchingList));
        this.getEditor().setText("");
    }

    public void setAutocompleteItems(List<? extends T> items) {
        this.setAutocompleteItems(items, null);
    }

    public final void setOnChangeConfirmed(EventHandler<Event> eh) {
        this.setOnHidden(e -> {
            String inputText = this.getEditor().getText();
            Object selectedItem = this.getSelectionModel().getSelectedItem();
            Object inputTextItem = this.getConverter().fromString(inputText);
            if (selectedItem != null && selectedItem.equals(inputTextItem)) {
                eh.handle(e);
                this.getParent().requestFocus();
                return;
            }
            if (inputText.isEmpty()) {
                eh.handle(e);
                this.getParent().requestFocus();
                UserThread.execute(() -> {
                    this.getSelectionModel().select(this.lastCommittedValue);
                    this.getEditor().setText(this.asString(this.lastCommittedValue));
                });
            }
        });
    }

    private void clearOnFocus() {
        this.getEditor().focusedProperty().addListener((observableValue, hadFocus, hasFocus) -> {
            if (!hadFocus.booleanValue() && hasFocus.booleanValue()) {
                this.removeFilter();
                this.forceRedraw();
            }
        });
    }

    private void setEmptySkinToGetMoreControlOverListView() {
        this.comboBoxListViewSkin = new JFXComboBoxListViewSkin((JFXComboBox)this);
        this.setSkin((Skin)this.comboBoxListViewSkin);
    }

    private void fixSpaceKey() {
        this.comboBoxListViewSkin.getPopupContent().addEventFilter(KeyEvent.ANY, event -> {
            if (event.getCode() == KeyCode.SPACE) {
                event.consume();
            }
        });
    }

    private void filterBy(String query) {
        this.matchingList = (this.extendedList != null && query.length() > 0 ? this.extendedList : this.list).stream().filter(item -> StringUtils.containsIgnoreCase((CharSequence)this.asString(item), (CharSequence)query)).collect(Collectors.toList());
        this.setValue(null);
        this.getSelectionModel().clearSelection();
        this.setItems(FXCollections.observableList(this.matchingList));
        int pos = this.getEditor().getCaretPosition();
        if (pos > query.length()) {
            pos = query.length();
        }
        this.getEditor().setText(query);
        this.getEditor().positionCaret(pos);
    }

    private void reactToQueryChanges() {
        this.getEditor().addEventHandler(KeyEvent.KEY_RELEASED, event -> {
            boolean isSelectAll;
            if (event.getCode() == KeyCode.CONTROL || event.getCode() == KeyCode.COMMAND || event.getCode() == KeyCode.META) {
                event.consume();
                return;
            }
            boolean bl = isSelectAll = event.getCode() == KeyCode.A && (event.isControlDown() || event.isMetaDown());
            if (isSelectAll) {
                this.getEditor().selectAll();
                this.selectAllShortcut = true;
                event.consume();
                return;
            }
            if (event.getCode() == KeyCode.A && this.selectAllShortcut) {
                this.selectAllShortcut = false;
                event.consume();
                return;
            }
            UserThread.execute(() -> {
                String query = this.getEditor().getText();
                boolean exactMatch = this.list.stream().anyMatch(item -> this.asString(item).equalsIgnoreCase(query));
                if (!exactMatch) {
                    if (query.isEmpty()) {
                        this.removeFilter();
                    } else {
                        this.filterBy(query);
                    }
                    this.forceRedraw();
                }
            });
        });
    }

    private void removeFilter() {
        this.matchingList = new ArrayList<T>(this.list);
        this.setValue(null);
        this.getSelectionModel().clearSelection();
        this.setItems(FXCollections.observableList(this.matchingList));
        this.getEditor().setText("");
    }

    private void forceRedraw() {
        this.adjustVisibleRowCount();
        if (this.matchingListSize() > 0) {
            this.comboBoxListViewSkin.getPopupContent().autosize();
            this.show();
            Node node = this.comboBoxListViewSkin.getPopupContent();
            if (node instanceof ListView) {
                ListView listView = (ListView)node;
                listView.applyCss();
                listView.layout();
            }
        } else {
            this.hide();
        }
    }

    private void adjustVisibleRowCount() {
        this.setVisibleRowCount(Math.min(10, this.matchingListSize()));
    }

    private String asString(T item) {
        return this.getConverter().toString(item);
    }

    private int matchingListSize() {
        return this.matchingList.size();
    }
}

