/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import de.jensd.fx.fontawesome.AwesomeIcon;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.PopOverWrapper;
import haveno.desktop.components.controlsfx.control.PopOver;
import haveno.desktop.util.FormBuilder;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.HBox;

public class AutoTooltipTableColumn<S, T>
extends TableColumn<S, T> {
    private Label helpIcon;
    private PopOverWrapper popoverWrapper = new PopOverWrapper();

    public AutoTooltipTableColumn(String text) {
        this.setTitle(text);
    }

    public AutoTooltipTableColumn(String text, String help) {
        this.setTitleWithHelpText(text, help);
    }

    public void setTitle(String title) {
        this.setGraphic((Node)new AutoTooltipLabel(title));
    }

    public void setTitleWithHelpText(String title, String help) {
        this.helpIcon = FormBuilder.getSmallIcon(AwesomeIcon.QUESTION_SIGN);
        this.helpIcon.setOpacity(0.4);
        this.helpIcon.setOnMouseEntered(e -> this.popoverWrapper.showPopOver(() -> this.createInfoPopOver(help)));
        this.helpIcon.setOnMouseExited(e -> this.popoverWrapper.hidePopOver());
        AutoTooltipLabel label = new AutoTooltipLabel(title);
        HBox hBox = new HBox(new Node[]{label, this.helpIcon});
        hBox.setStyle("-fx-alignment: center-left");
        hBox.setSpacing(4.0);
        this.setGraphic((Node)hBox);
    }

    private PopOver createInfoPopOver(String help) {
        Label helpLabel = new Label(help);
        helpLabel.setMaxWidth(300.0);
        helpLabel.setWrapText(true);
        return this.createInfoPopOver((Node)helpLabel);
    }

    private PopOver createInfoPopOver(Node node) {
        node.getStyleClass().add((Object)"default-text");
        PopOver infoPopover = new PopOver(node);
        if (this.helpIcon.getScene() != null) {
            infoPopover.setDetachable(false);
            infoPopover.setArrowLocation(PopOver.ArrowLocation.LEFT_CENTER);
            infoPopover.show((Node)this.helpIcon, -10.0);
        }
        return infoPopover;
    }
}

