/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import de.jensd.fx.fontawesome.AwesomeDude;
import de.jensd.fx.fontawesome.AwesomeIcon;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.ExternalHyperlink;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressWithIconAndDirection
extends HBox {
    private static final Logger log = LoggerFactory.getLogger(AddressWithIconAndDirection.class);
    private final Hyperlink hyperlink;

    public AddressWithIconAndDirection(String text, String address, boolean received) {
        Label directionIcon = new Label();
        directionIcon.getStyleClass().add((Object)"icon");
        directionIcon.getStyleClass().add((Object)(received ? "received-funds-icon" : "sent-funds-icon"));
        AwesomeDude.setIcon((Label)directionIcon, (AwesomeIcon)(received ? AwesomeIcon.SIGNIN : AwesomeIcon.SIGNOUT));
        if (received) {
            directionIcon.setRotate(180.0);
        }
        directionIcon.setMouseTransparent(true);
        this.setAlignment(Pos.CENTER_LEFT);
        AutoTooltipLabel label = new AutoTooltipLabel(text);
        label.setMouseTransparent(true);
        HBox.setMargin((Node)directionIcon, (Insets)new Insets(0.0, 3.0, 0.0, 0.0));
        HBox.setHgrow((Node)label, (Priority)Priority.ALWAYS);
        this.hyperlink = new ExternalHyperlink(address);
        HBox.setMargin((Node)this.hyperlink, (Insets)new Insets(0.0));
        HBox.setHgrow((Node)this.hyperlink, (Priority)Priority.SOMETIMES);
        this.hyperlink.setMaxWidth(Double.MAX_VALUE);
        this.hyperlink.setPrefWidth(0.0);
        this.getChildren().addAll((Object[])new Node[]{directionIcon, label, this.hyperlink});
    }

    public void setOnAction(EventHandler<ActionEvent> handler) {
        this.hyperlink.setOnAction(handler);
    }

    public void setTooltip(Tooltip tooltip) {
        this.hyperlink.setTooltip(tooltip);
    }
}

