/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import de.jensd.fx.fontawesome.AwesomeDude;
import de.jensd.fx.fontawesome.AwesomeIcon;
import haveno.common.UserThread;
import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.desktop.components.HavenoTextField;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.GUIUtil;
import haveno.desktop.util.Layout;
import java.math.BigInteger;
import java.net.URI;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressTextField
extends AnchorPane {
    private static final Logger log = LoggerFactory.getLogger(AddressTextField.class);
    private final StringProperty address = new SimpleStringProperty();
    private final StringProperty paymentLabel = new SimpleStringProperty();
    private final ObjectProperty<BigInteger> amount = new SimpleObjectProperty((Object)BigInteger.ZERO);
    private boolean wasPrimaryButtonDown;

    public AddressTextField(String label) {
        HavenoTextField textField = new HavenoTextField();
        textField.setId("address-text-field");
        textField.setEditable(false);
        textField.setLabelFloat(true);
        textField.getStyleClass().add((Object)"label-float");
        textField.setPromptText(label);
        textField.textProperty().bind((ObservableValue)this.address);
        String tooltipText = Res.get((String)"addressTextField.openWallet");
        textField.setTooltip(new Tooltip(tooltipText));
        textField.setOnMousePressed(event -> {
            this.wasPrimaryButtonDown = event.isPrimaryButtonDown();
        });
        textField.setOnMouseReleased(event -> {
            if (this.wasPrimaryButtonDown) {
                this.openWallet();
            }
            this.wasPrimaryButtonDown = false;
        });
        textField.focusTraversableProperty().set(this.focusTraversableProperty().get());
        Label extWalletIcon = new Label();
        extWalletIcon.setLayoutY(9.0);
        extWalletIcon.getStyleClass().addAll((Object[])new String[]{"icon", "highlight"});
        extWalletIcon.setTooltip(new Tooltip(tooltipText));
        AwesomeDude.setIcon((Label)extWalletIcon, (AwesomeIcon)AwesomeIcon.SIGNIN);
        extWalletIcon.setOnMouseClicked(e -> this.openWallet());
        Label copyLabel = new Label();
        copyLabel.setLayoutY(9.0);
        copyLabel.getStyleClass().addAll((Object[])new String[]{"icon", "highlight"});
        Tooltip.install((Node)copyLabel, (Tooltip)new Tooltip(Res.get((String)"addressTextField.copyToClipboard")));
        copyLabel.setGraphic((Node)GUIUtil.getCopyIcon());
        copyLabel.setOnMouseClicked(e -> {
            if (this.address.get() != null && ((String)this.address.get()).length() > 0) {
                Utilities.copyToClipboard((String)((String)this.address.get()));
            }
            Tooltip tp = new Tooltip(Res.get((String)"shared.copiedToClipboard"));
            Node node = (Node)e.getSource();
            UserThread.runAfter(() -> tp.hide(), (long)1L);
            tp.show(node, e.getScreenX() + Layout.PADDING, e.getScreenY() + Layout.PADDING);
        });
        AnchorPane.setRightAnchor((Node)copyLabel, (Double)30.0);
        AnchorPane.setRightAnchor((Node)extWalletIcon, (Double)5.0);
        AnchorPane.setRightAnchor((Node)textField, (Double)55.0);
        AnchorPane.setLeftAnchor((Node)textField, (Double)0.0);
        this.getChildren().addAll((Object[])new Node[]{textField, copyLabel, extWalletIcon});
    }

    private void openWallet() {
        try {
            Utilities.openURI((URI)URI.create(this.getMoneroURI()));
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            ((Popup)new Popup().warning(Res.get((String)"addressTextField.openWallet.failed"))).show();
        }
    }

    public void setAddress(String address) {
        this.address.set((Object)address);
    }

    public String getAddress() {
        return (String)this.address.get();
    }

    public StringProperty addressProperty() {
        return this.address;
    }

    public BigInteger getAmount() {
        return (BigInteger)this.amount.get();
    }

    public ObjectProperty<BigInteger> amountAsProperty() {
        return this.amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount.set((Object)amount);
    }

    public String getPaymentLabel() {
        return (String)this.paymentLabel.get();
    }

    public StringProperty paymentLabelProperty() {
        return this.paymentLabel;
    }

    public void setPaymentLabel(String paymentLabel) {
        this.paymentLabel.set((Object)paymentLabel);
    }

    private String getMoneroURI() {
        if (((BigInteger)this.amount.get()).compareTo(BigInteger.ZERO) < 0) {
            log.warn("Amount must not be negative");
            this.setAmount(BigInteger.ZERO);
        }
        return GUIUtil.getMoneroURI((String)this.address.get(), (BigInteger)this.amount.get(), (String)this.paymentLabel.get());
    }
}

