/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import haveno.common.UserThread;
import haveno.core.locale.Res;
import haveno.core.offer.OfferRestrictions;
import haveno.core.trade.HavenoUtils;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.ExternalHyperlink;
import haveno.desktop.components.controlsfx.control.PopOver;
import haveno.desktop.main.offer.offerbook.OfferBookListItem;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import java.math.BigInteger;
import java.util.concurrent.TimeUnit;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;

public class AccountStatusTooltipLabel
extends AutoTooltipLabel {
    public static final int DEFAULT_WIDTH = 300;
    private final Node textIcon;
    private final OfferBookListItem.WitnessAgeData witnessAgeData;
    private final String popupTitle;
    private PopOver popOver;
    private boolean keepPopOverVisible = false;

    public AccountStatusTooltipLabel(OfferBookListItem.WitnessAgeData witnessAgeData) {
        super(witnessAgeData.getDisplayString());
        this.witnessAgeData = witnessAgeData;
        this.textIcon = FormBuilder.getIcon(witnessAgeData.getIcon());
        this.popupTitle = witnessAgeData.isLimitLifted() ? Res.get((String)"offerbook.timeSinceSigning.tooltip.accountLimitLifted") : Res.get((String)"offerbook.timeSinceSigning.tooltip.accountLimit", (Object[])new Object[]{HavenoUtils.formatXmr((BigInteger)OfferRestrictions.TOLERATED_SMALL_TRADE_AMOUNT, (boolean)true)});
        this.positionAndActivateIcon();
    }

    private void positionAndActivateIcon() {
        this.textIcon.setOpacity(0.4);
        this.textIcon.getStyleClass().add((Object)"tooltip-icon");
        this.popOver = this.createPopOver();
        this.textIcon.setOnMouseEntered(e -> this.showPopup(this.textIcon));
        this.textIcon.setOnMouseExited(e -> UserThread.runAfter(() -> {
            if (!this.keepPopOverVisible) {
                this.popOver.hide();
            }
        }, (long)200L, (TimeUnit)TimeUnit.MILLISECONDS));
        this.setGraphic(this.textIcon);
        this.setContentDisplay(ContentDisplay.RIGHT);
    }

    private PopOver createPopOver() {
        Label titleLabel = new Label(this.popupTitle);
        titleLabel.setMaxWidth(300.0);
        titleLabel.setWrapText(true);
        titleLabel.setPadding(new Insets(10.0, 10.0, 0.0, 10.0));
        titleLabel.getStyleClass().add((Object)"account-status-title");
        Label infoLabel = new Label(this.witnessAgeData.getInfo());
        infoLabel.setMaxWidth(300.0);
        infoLabel.setWrapText(true);
        infoLabel.setPadding(new Insets(0.0, 10.0, 4.0, 10.0));
        infoLabel.getStyleClass().add((Object)"small-text");
        Label buyLabel = this.createDetailsItem(Res.get((String)"offerbook.timeSinceSigning.tooltip.checkmark.buyXmr"), this.witnessAgeData.isAccountSigned());
        Label waitLabel = this.createDetailsItem(Res.get((String)"offerbook.timeSinceSigning.tooltip.checkmark.wait", (Object[])new Object[]{30L}), this.witnessAgeData.isLimitLifted());
        ExternalHyperlink learnMoreLink = new ExternalHyperlink(Res.get((String)"offerbook.timeSinceSigning.tooltip.learnMore"), null, "0.769em");
        learnMoreLink.setMaxWidth(300.0);
        learnMoreLink.setWrapText(true);
        learnMoreLink.setPadding(new Insets(10.0, 10.0, 2.0, 10.0));
        learnMoreLink.getStyleClass().addAll((Object[])new String[]{"very-small-text"});
        learnMoreLink.setOnAction(e -> GUIUtil.openWebPage("https://docs.haveno.exchange/the-project/account_limits"));
        VBox vBox = new VBox(2.0, new Node[]{titleLabel, infoLabel, buyLabel, waitLabel, learnMoreLink});
        vBox.setPadding(new Insets(2.0, 0.0, 2.0, 0.0));
        vBox.setAlignment(Pos.CENTER_LEFT);
        PopOver popOver = new PopOver((Node)vBox);
        popOver.setArrowLocation(PopOver.ArrowLocation.LEFT_CENTER);
        vBox.setOnMouseEntered(mouseEvent -> {
            this.keepPopOverVisible = true;
        });
        vBox.setOnMouseExited(mouseEvent -> {
            this.keepPopOverVisible = false;
            popOver.hide();
        });
        return popOver;
    }

    private void showPopup(Node textIcon) {
        Bounds bounds = textIcon.localToScreen(textIcon.getBoundsInLocal());
        this.popOver.show(textIcon, bounds.getMaxX() + 10.0, bounds.getMinY() + bounds.getHeight() / 2.0 - 10.0);
    }

    private Label createDetailsItem(String text, boolean active) {
        Label label = new Label(text);
        label.setMaxWidth(300.0);
        label.setWrapText(true);
        label.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
        label.getStyleClass().add((Object)"small-text");
        if (active) {
            label.setStyle("-fx-text-fill: -fx-accent");
        } else {
            label.setStyle("-fx-text-fill: -bs-color-gray-dim");
        }
        Text icon = FormBuilder.getSmallIconForLabel((GlyphIcons)(active ? MaterialDesignIcon.CHECKBOX_MARKED_CIRCLE : MaterialDesignIcon.CLOSE_CIRCLE), label);
        icon.setLayoutY(4.0);
        if (active) {
            icon.getStyleClass().add((Object)"account-status-active-info-item");
        } else {
            icon.getStyleClass().add((Object)"account-status-inactive-info-item");
        }
        return label;
    }
}

