/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.common.view;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.desktop.common.view.View;
import haveno.desktop.common.view.ViewLoader;
import java.util.HashMap;
import java.util.Map;

@Singleton
public class CachingViewLoader
implements ViewLoader {
    private final Map<Class<? extends View>, View> cache = new HashMap<Class<? extends View>, View>();
    private final ViewLoader viewLoader;

    @Inject
    public CachingViewLoader(ViewLoader viewLoader) {
        this.viewLoader = viewLoader;
    }

    @Override
    public View load(Class<? extends View> viewClass) {
        if (this.cache.containsKey(viewClass)) {
            return this.cache.get(viewClass);
        }
        View view = this.viewLoader.load(viewClass);
        this.cache.put(viewClass, view);
        return view;
    }

    public void removeFromCache(Class<? extends View> viewClass) {
        this.cache.remove(viewClass);
    }
}

