/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.common.fxml;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.util.Utilities;
import haveno.desktop.common.ViewfxException;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.common.view.View;
import haveno.desktop.common.view.ViewFactory;
import haveno.desktop.common.view.ViewLoader;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FxmlViewLoader
implements ViewLoader {
    private static final Logger log = LoggerFactory.getLogger(FxmlViewLoader.class);
    private final ViewFactory viewFactory;
    private final ResourceBundle resourceBundle;

    @Inject
    public FxmlViewLoader(ViewFactory viewFactory, ResourceBundle resourceBundle) {
        this.viewFactory = viewFactory;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public View load(Class<? extends View> viewClass) {
        String specifiedLocation;
        Class<? extends FxmlView.PathConvention> convention;
        FxmlView fxmlView = viewClass.getAnnotation(FxmlView.class);
        Class<? extends FxmlView.PathConvention> defaultConvention = (Class<? extends FxmlView.PathConvention>)FxmlViewLoader.getDefaultValue(FxmlView.class, "convention");
        String defaultLocation = (String)FxmlViewLoader.getDefaultValue(FxmlView.class, "location");
        if (fxmlView == null) {
            convention = defaultConvention;
            specifiedLocation = defaultLocation;
        } else {
            convention = fxmlView.convention();
            specifiedLocation = fxmlView.location();
        }
        if (convention == null || specifiedLocation == null) {
            throw new IllegalStateException("Convention and location should never be null.");
        }
        try {
            String resolvedLocation = specifiedLocation.equals(defaultLocation) ? (String)convention.newInstance().apply(viewClass) : specifiedLocation;
            URL fxmlUrl = viewClass.getClassLoader().getResource(resolvedLocation);
            if (fxmlUrl == null) {
                throw new ViewfxException("Failed to load view class [%s] because FXML file at [%s] could not be loaded as a classpath resource. Does it exist?", viewClass, specifiedLocation);
            }
            return this.loadFromFxml(fxmlUrl);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new ViewfxException(ex, "Failed to load view from class %s", viewClass);
        }
    }

    private View loadFromFxml(URL fxmlUrl) {
        Preconditions.checkNotNull((Object)fxmlUrl, (Object)"FXML URL must not be null");
        try {
            FXMLLoader loader = new FXMLLoader(fxmlUrl, this.resourceBundle);
            loader.setControllerFactory((Callback)this.viewFactory);
            loader.load();
            Object controller = loader.getController();
            if (controller == null) {
                throw new ViewfxException("Failed to load view from FXML file at [%s]. Does it declare an fx:controller attribute?", fxmlUrl);
            }
            if (!(controller instanceof View)) {
                throw new ViewfxException("Controller of type [%s] loaded from FXML file at [%s] does not implement [%s] as expected.", controller.getClass(), fxmlUrl, View.class);
            }
            return (View)controller;
        }
        catch (IOException ex) {
            Throwable cause = ex.getCause();
            if (cause != null) {
                cause.printStackTrace();
                log.error(cause.toString());
                String stackTrace = Utilities.toTruncatedString((Object)Joiner.on((String)"\n").join((Object[])cause.getStackTrace()), (int)800, (boolean)false);
                throw new ViewfxException(cause, "%s at loading view class\nStack trace:\n%s", cause.getClass().getSimpleName(), stackTrace);
            }
            throw new ViewfxException(ex, "Failed to load view from FXML file at [%s]", fxmlUrl);
        }
    }

    private static Object getDefaultValue(Class<? extends Annotation> annotationType, String attributeName) {
        if (annotationType == null || attributeName == null || attributeName.length() == 0) {
            return null;
        }
        try {
            return annotationType.getDeclaredMethod(attributeName, new Class[0]).getDefaultValue();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

