/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.common;

import haveno.common.UserThread;
import haveno.common.reactfx.FxTimer;
import haveno.common.reactfx.Timer;
import java.time.Duration;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UITimer
implements haveno.common.Timer {
    private final Logger log = LoggerFactory.getLogger(UITimer.class);
    private Timer timer;

    public haveno.common.Timer runLater(Duration delay, Runnable runnable) {
        this.executeDirectlyIfPossible(() -> {
            if (this.timer == null) {
                this.timer = FxTimer.create((Duration)delay, (Runnable)runnable);
                this.timer.restart();
            } else {
                this.log.warn("runLater called on an already running timer.");
            }
        });
        return this;
    }

    public haveno.common.Timer runPeriodically(Duration interval, Runnable runnable) {
        this.executeDirectlyIfPossible(() -> {
            if (this.timer == null) {
                this.timer = FxTimer.createPeriodic((Duration)interval, (Runnable)runnable);
                this.timer.restart();
            } else {
                this.log.warn("runPeriodically called on an already running timer.");
            }
        });
        return this;
    }

    public void stop() {
        this.executeDirectlyIfPossible(() -> {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        });
    }

    private void executeDirectlyIfPossible(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            UserThread.execute((Runnable)runnable);
        }
    }
}

