/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.app;

import haveno.common.UserThread;
import haveno.common.app.AppModule;
import haveno.common.crypto.IncorrectPasswordException;
import haveno.common.setup.GracefulShutDownHandler;
import haveno.core.app.AvoidStandbyModeService;
import haveno.core.app.HavenoExecutable;
import haveno.desktop.app.HavenoApp;
import haveno.desktop.app.HavenoAppModule;
import haveno.desktop.common.UITimer;
import haveno.desktop.common.view.guice.InjectorViewFactory;
import haveno.desktop.setup.DesktopPersistedDataHost;
import haveno.desktop.util.ImageUtil;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HavenoAppMain
extends HavenoExecutable {
    private static final Logger log = LoggerFactory.getLogger(HavenoAppMain.class);
    private HavenoApp application;

    public HavenoAppMain() {
        super("Haveno Desktop", "haveno-desktop", "Haveno-reto", "1.2.2");
    }

    public static void main(String[] args) {
        Thread.currentThread().setContextClassLoader(HavenoAppMain.class.getClassLoader());
        new HavenoAppMain().execute(args);
    }

    public void onSetupComplete() {
        log.debug("onSetupComplete");
    }

    protected void configUserThread() {
        UserThread.setExecutor(Platform::runLater);
        UserThread.setTimerClass(UITimer.class);
    }

    protected void launchApplication() {
        HavenoApp.setAppLaunchedHandler(application -> {
            this.application = (HavenoApp)((Object)application);
            UserThread.execute(this::onApplicationLaunched);
        });
        Application.launch(HavenoApp.class, (String[])new String[0]);
    }

    protected void onApplicationLaunched() {
        super.onApplicationLaunched();
        this.application.setGracefulShutDownHandler((GracefulShutDownHandler)this);
    }

    public void handleUncaughtException(Throwable throwable, boolean doShutDown) {
        this.application.handleUncaughtException(throwable, doShutDown);
    }

    protected AppModule getModule() {
        return new HavenoAppModule(this.config);
    }

    protected void applyInjector() {
        super.applyInjector();
        this.application.setInjector(this.injector);
        ((InjectorViewFactory)this.injector.getInstance(InjectorViewFactory.class)).setInjector(this.injector);
    }

    protected void readAllPersisted(Runnable completeHandler) {
        super.readAllPersisted(DesktopPersistedDataHost.getPersistedDataHosts(this.injector), completeHandler);
    }

    protected void setupAvoidStandbyMode() {
        ((AvoidStandbyModeService)this.injector.getInstance(AvoidStandbyModeService.class)).init();
    }

    protected void startApplication() {
        this.application.startApplication(this::onApplicationStarted);
    }

    protected void onApplicationStarted() {
        super.onApplicationStarted();
        log.info("Using JavaFX {}", (Object)System.getProperty("javafx.version"));
    }

    protected CompletableFuture<Boolean> loginAccount() {
        CompletableFuture result = super.loginAccount();
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return result;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
        CompletableFuture<Boolean> dialogResult = new CompletableFuture<Boolean>();
        Platform.setImplicitExit((boolean)false);
        Platform.runLater(() -> {
            String errorMessage = null;
            while (!this.accountService.isAccountOpen()) {
                PasswordDialog passwordDialog = new PasswordDialog(this, errorMessage);
                Optional passwordResult = passwordDialog.showAndWait();
                if (passwordResult.isPresent()) {
                    try {
                        this.accountService.openAccount((String)passwordResult.get());
                        dialogResult.complete(this.accountService.isAccountOpen());
                    }
                    catch (IncorrectPasswordException e) {
                        errorMessage = "Incorrect password";
                    }
                    continue;
                }
                dialogResult.completeExceptionally(new Exception("Password dialog cancelled"));
                break;
            }
        });
        return dialogResult;
    }

    private class PasswordDialog
    extends Dialog<String> {
        public PasswordDialog(HavenoAppMain havenoAppMain, String errorMessage) {
            this.setTitle("Enter Password");
            this.setHeaderText("Please enter your Haveno password:");
            Stage stage = (Stage)this.getDialogPane().getScene().getWindow();
            stage.getIcons().add((Object)ImageUtil.getImageByPath("lock@2x.png"));
            PasswordField passwordField = new PasswordField();
            passwordField.setPromptText("Password");
            Label errorMessageField = new Label(errorMessage);
            errorMessageField.setTextFill((Paint)Color.color((double)1.0, (double)0.0, (double)0.0));
            Label versionField = new Label("v1.2.2");
            VBox vbox = new VBox(10.0);
            ImageView logoImageView = new ImageView(ImageUtil.getImageByPath("logo_splash_light_mode.png"));
            logoImageView.setFitWidth(342.0);
            logoImageView.setPreserveRatio(true);
            vbox.getChildren().addAll((Object[])new Node[]{logoImageView, passwordField, errorMessageField, versionField});
            vbox.setAlignment(Pos.TOP_CENTER);
            this.getDialogPane().setContent((Node)vbox);
            ButtonType okButton = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
            ButtonType cancelButton = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
            this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{okButton, cancelButton});
            this.setResultConverter(buttonType -> {
                if (buttonType == okButton) {
                    return passwordField.getText();
                }
                new Thread(() -> HavenoApp.getShutDownHandler().run()).start();
                return null;
            });
            Window window = this.getDialogPane().getScene().getWindow();
            if (window instanceof Stage) {
                Stage dialogStage = (Stage)window;
                dialogStage.focusedProperty().addListener((observable, oldValue, newValue) -> {
                    if (newValue.booleanValue()) {
                        passwordField.requestFocus();
                    }
                });
            }
        }
    }
}

