/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.app;

import ch.qos.logback.classic.Level;
import com.google.common.base.Joiner;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import haveno.common.app.DevEnv;
import haveno.common.app.Log;
import haveno.common.config.Config;
import haveno.common.crypto.Hash;
import haveno.common.setup.GracefulShutDownHandler;
import haveno.common.setup.UncaughtExceptionHandler;
import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.core.offer.OpenOfferManager;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.support.dispute.mediation.MediationManager;
import haveno.core.support.dispute.refund.RefundManager;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.user.Cookie;
import haveno.core.user.CookieKey;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.core.xmr.wallet.WalletsManager;
import haveno.desktop.common.view.CachingViewLoader;
import haveno.desktop.common.view.View;
import haveno.desktop.common.view.ViewLoader;
import haveno.desktop.main.MainView;
import haveno.desktop.main.debug.DebugView;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.FilterWindow;
import haveno.desktop.main.overlays.windows.SendAlertMessageWindow;
import haveno.desktop.main.overlays.windows.ShowWalletDataWindow;
import haveno.desktop.util.CssTheme;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.ImageUtil;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javafx.application.Application;
import javafx.geometry.BoundingBox;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HavenoApp
extends Application
implements UncaughtExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(HavenoApp.class);
    private static Consumer<Application> appLaunchedHandler;
    private static Runnable shutDownHandler;
    private static Runnable onGracefulShutDownHandler;
    private Injector injector;
    private GracefulShutDownHandler gracefulShutDownHandler;
    private Stage stage;
    private boolean popupOpened;
    private Scene scene;
    private boolean shutDownRequested;
    private MainView mainView;

    public HavenoApp() {
        shutDownHandler = this::stop;
    }

    public void init() {
    }

    public void start(Stage stage) {
        this.stage = stage;
        appLaunchedHandler.accept(this);
    }

    public void startApplication(Runnable onApplicationStartedHandler) {
        log.info("Starting application");
        try {
            this.mainView = this.loadMainView(this.injector);
            this.mainView.setOnApplicationStartedHandler(onApplicationStartedHandler);
            this.scene = this.createAndConfigScene(this.mainView, this.injector);
            this.setupStage(this.scene);
        }
        catch (Throwable throwable) {
            log.error("Error during app init", throwable);
            this.handleUncaughtException(throwable, false);
        }
    }

    public void stop() {
        if (!this.shutDownRequested) {
            ((Popup)((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"popup.shutDownInProgress.headline"))).backgroundInfo(Res.get((String)"popup.shutDownInProgress.msg"))).hideCloseButton()).useAnimation(false)).show();
            new Thread(() -> this.gracefulShutDownHandler.gracefulShutDown(() -> {
                log.info("App shutdown complete");
                if (onGracefulShutDownHandler != null) {
                    onGracefulShutDownHandler.run();
                }
            })).start();
            this.shutDownRequested = true;
        }
    }

    public void handleUncaughtException(Throwable throwable, boolean doShutDown) {
        block8: {
            if (!this.shutDownRequested) {
                if (this.scene == null) {
                    log.warn("Scene not available yet, we create a new scene. The bug might be caused by an exception in a constructor or by a circular dependency in Guice. throwable=" + throwable.toString());
                    this.scene = new Scene((Parent)new StackPane(), 1000.0, 650.0);
                    CssTheme.loadSceneStyles(this.scene, 0, false);
                    this.stage.setScene(this.scene);
                    this.stage.show();
                }
                try {
                    try {
                        if (!this.popupOpened) {
                            this.popupOpened = true;
                            ((Popup)((Popup)new Popup().error(Objects.requireNonNullElse(throwable.getMessage(), throwable.toString()))).onClose(() -> {
                                this.popupOpened = false;
                            })).show();
                        }
                    }
                    catch (Throwable throwable3) {
                        log.error("Error at displaying Throwable.");
                        throwable3.printStackTrace();
                    }
                    if (doShutDown) {
                        this.stop();
                    }
                }
                catch (Throwable throwable2) {
                    log.error(throwable2.toString());
                    if (!doShutDown) break block8;
                    this.stop();
                }
            }
        }
    }

    private Scene createAndConfigScene(MainView mainView, Injector injector) {
        Rectangle2D maxWindowBounds = new Rectangle2D(0.0, 0.0, 0.0, 0.0);
        try {
            maxWindowBounds = Screen.getPrimary().getBounds();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Scene scene = new Scene((Parent)mainView.getRoot(), maxWindowBounds.getWidth() < 1200.0 ? Math.max(maxWindowBounds.getWidth(), 1020.0) : 1200.0, maxWindowBounds.getHeight() < 710.0 ? Math.max(maxWindowBounds.getHeight(), 620.0) : 710.0);
        this.addSceneKeyEventHandler(scene, injector);
        Preferences preferences = (Preferences)injector.getInstance(Preferences.class);
        Config config = (Config)injector.getInstance(Config.class);
        preferences.getCssThemeProperty().addListener(ov -> CssTheme.loadSceneStyles(scene, preferences.getCssTheme(), config.useDevModeHeader));
        CssTheme.loadSceneStyles(scene, preferences.getCssTheme(), config.useDevModeHeader);
        scene.setFill((Paint)(CssTheme.isDarkTheme() ? Color.BLACK : Color.WHITE));
        return scene;
    }

    private void setupStage(Scene scene) {
        this.stage.setOnCloseRequest(event -> {
            event.consume();
            this.shutDownByUser();
        });
        Object appName = (String)this.injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"appName")));
        ArrayList<String> postFixes = new ArrayList<String>();
        if (!Config.baseCurrencyNetwork().isMainnet()) {
            postFixes.add(Config.baseCurrencyNetwork().name());
        }
        if (((Config)this.injector.getInstance(Config.class)).useLocalhostForP2P) {
            postFixes.add("LOCALHOST");
        }
        if (((Config)this.injector.getInstance(Config.class)).useDevMode) {
            postFixes.add("DEV MODE");
        }
        if (!postFixes.isEmpty()) {
            appName = (String)appName + " [" + Joiner.on((String)", ").join(postFixes) + "]";
        }
        this.stage.setTitle((String)appName);
        this.stage.setScene(scene);
        this.stage.setMinWidth(1020.0);
        this.stage.setMinHeight(620.0);
        this.stage.getIcons().add((Object)ImageUtil.getApplicationIconImage());
        User user = (User)this.injector.getInstance(User.class);
        this.layoutStageFromPersistedData(this.stage, user);
        this.addStageLayoutListeners(this.stage, user);
        this.stage.show();
    }

    private void layoutStageFromPersistedData(Stage stage, User user) {
        Cookie cookie = user.getCookie();
        cookie.getAsOptionalDouble(CookieKey.STAGE_X).flatMap(x -> cookie.getAsOptionalDouble(CookieKey.STAGE_Y).flatMap(y -> cookie.getAsOptionalDouble(CookieKey.STAGE_W).flatMap(w -> cookie.getAsOptionalDouble(CookieKey.STAGE_H).map(h -> new BoundingBox(x.doubleValue(), y.doubleValue(), w.doubleValue(), h.doubleValue()))))).ifPresent(stageBoundingBox -> {
            stage.setX(stageBoundingBox.getMinX());
            stage.setY(stageBoundingBox.getMinY());
            stage.setWidth(stageBoundingBox.getWidth());
            stage.setHeight(stageBoundingBox.getHeight());
        });
    }

    private void addStageLayoutListeners(Stage stage, User user) {
        stage.widthProperty().addListener((observable, oldValue, newValue) -> {
            user.getCookie().putAsDouble(CookieKey.STAGE_W, ((Double)newValue).doubleValue());
            user.requestPersistence();
        });
        stage.heightProperty().addListener((observable, oldValue, newValue) -> {
            user.getCookie().putAsDouble(CookieKey.STAGE_H, ((Double)newValue).doubleValue());
            user.requestPersistence();
        });
        stage.xProperty().addListener((observable, oldValue, newValue) -> {
            user.getCookie().putAsDouble(CookieKey.STAGE_X, ((Double)newValue).doubleValue());
            user.requestPersistence();
        });
        stage.yProperty().addListener((observable, oldValue, newValue) -> {
            user.getCookie().putAsDouble(CookieKey.STAGE_Y, ((Double)newValue).doubleValue());
            user.requestPersistence();
        });
    }

    private MainView loadMainView(Injector injector) {
        CachingViewLoader viewLoader = (CachingViewLoader)injector.getInstance(CachingViewLoader.class);
        return (MainView)viewLoader.load(MainView.class);
    }

    private void addSceneKeyEventHandler(Scene scene, Injector injector) {
        scene.addEventHandler(KeyEvent.KEY_RELEASED, keyEvent -> {
            if (Utilities.isCtrlPressed((KeyCode)KeyCode.W, (KeyEvent)keyEvent) || Utilities.isCtrlPressed((KeyCode)KeyCode.Q, (KeyEvent)keyEvent)) {
                this.shutDownByUser();
            } else if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.M, (KeyEvent)keyEvent)) {
                ((SendAlertMessageWindow)injector.getInstance(SendAlertMessageWindow.class)).show();
            } else if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.F, (KeyEvent)keyEvent)) {
                ((FilterWindow)injector.getInstance(FilterWindow.class)).show();
            } else if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.T, (KeyEvent)keyEvent)) {
                String pattern = "org.berndpruenster.netlayer";
                Level logLevel = ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)pattern)).getLevel();
                if (logLevel != Level.DEBUG) {
                    log.info("Set log level for org.berndpruenster.netlayer classes to DEBUG");
                    Log.setCustomLogLevel((String)pattern, (Level)Level.DEBUG);
                } else {
                    log.info("Set log level for org.berndpruenster.netlayer classes to WARN");
                    Log.setCustomLogLevel((String)pattern, (Level)Level.WARN);
                }
            } else if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.J, (KeyEvent)keyEvent)) {
                WalletsManager walletsManager = (WalletsManager)injector.getInstance(WalletsManager.class);
                if (walletsManager.areWalletsAvailable()) {
                    new ShowWalletDataWindow(walletsManager).show();
                } else {
                    ((Popup)new Popup().warning(Res.get((String)"popup.warning.walletNotInitialized"))).show();
                }
            } else if (DevEnv.isDevMode() && Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.Z, (KeyEvent)keyEvent)) {
                this.showDebugWindow(scene, injector);
            }
        });
    }

    private void shutDownByUser() {
        this.promptUserAtShutdown().thenAccept(okToShutDown -> {
            if (okToShutDown.booleanValue()) {
                this.stop();
            }
        });
    }

    private CompletableFuture<Boolean> promptUserAtShutdown() {
        String key;
        CompletableFuture<Boolean> resp = new CompletableFuture<Boolean>();
        String issues = this.checkTradesAtShutdown() + this.checkDisputesAtShutdown();
        if (issues.length() > 0) {
            key = Utilities.encodeToHex((byte[])Hash.getSha256Hash((String)issues));
            if (((Preferences)this.injector.getInstance(Preferences.class)).showAgain(key) && !DevEnv.isDevMode()) {
                ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().warning(issues)).actionButtonText(Res.get((String)"shared.okWait"))).onAction(() -> resp.complete(false))).closeButtonText(Res.get((String)"shared.closeAnywayDanger"))).onClose(() -> resp.complete(true))).dontShowAgainId(key)).width(800.0)).show();
                return resp;
            }
        }
        if (((OpenOfferManager)this.injector.getInstance(OpenOfferManager.class)).hasAvailableOpenOffers()) {
            key = "showOpenOfferWarnPopupAtShutDown";
            if (((Preferences)this.injector.getInstance(Preferences.class)).showAgain(key) && !DevEnv.isDevMode()) {
                ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"popup.info.shutDownWithOpenOffers"))).actionButtonText(Res.get((String)"shared.shutDown"))).onAction(() -> resp.complete(true))).closeButtonText(Res.get((String)"shared.cancel"))).onClose(() -> resp.complete(false))).dontShowAgainId(key)).show();
                return resp;
            }
        }
        key = "popup.info.shutDownQuery";
        if (((Preferences)this.injector.getInstance(Preferences.class)).showAgain(key) && !DevEnv.isDevMode()) {
            ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)key))).actionButtonText(Res.get((String)"shared.yes"))).onAction(() -> resp.complete(true))).closeButtonText(Res.get((String)"shared.no"))).onClose(() -> resp.complete(false))).dontShowAgainId(key)).show();
        } else {
            resp.complete(true);
        }
        return resp;
    }

    private String checkTradesAtShutdown() {
        log.info("Checking trades at shutdown");
        Instant fiveMinutesAgo = Instant.ofEpochSecond(Instant.now().getEpochSecond() - TimeUnit.MINUTES.toSeconds(5L));
        for (Trade trade : ((TradeManager)this.injector.getInstance(TradeManager.class)).getObservableList()) {
            if (!trade.getPhase().equals((Object)Trade.Phase.DEPOSIT_REQUESTED) || !trade.getTakeOfferDate().toInstant().isAfter(fiveMinutesAgo)) continue;
            String tradeDateString = DisplayUtils.formatDateTime(trade.getTakeOfferDate());
            String tradeInfo = Res.get((String)"shared.tradeId") + ": " + trade.getShortId() + " " + Res.get((String)"shared.dateTime") + ": " + tradeDateString;
            return Res.get((String)"popup.info.shutDownWithTradeInit", (Object[])new Object[]{tradeInfo}) + System.lineSeparator() + System.lineSeparator();
        }
        return "";
    }

    private String checkDisputesAtShutdown() {
        log.info("Checking disputes at shutdown");
        if (((ArbitrationManager)this.injector.getInstance(ArbitrationManager.class)).hasPendingMessageAtShutdown() || ((MediationManager)this.injector.getInstance(MediationManager.class)).hasPendingMessageAtShutdown() || ((RefundManager)this.injector.getInstance(RefundManager.class)).hasPendingMessageAtShutdown()) {
            return Res.get((String)"popup.info.shutDownWithDisputeInit") + System.lineSeparator() + System.lineSeparator();
        }
        return "";
    }

    private void showDebugWindow(Scene scene, Injector injector) {
        ViewLoader viewLoader = (ViewLoader)injector.getInstance(ViewLoader.class);
        View debugView = viewLoader.load(DebugView.class);
        Parent parent = (Parent)debugView.getRoot();
        Stage stage = new Stage();
        stage.setScene(new Scene(parent));
        stage.setTitle("Debug window");
        stage.initModality(Modality.NONE);
        stage.initStyle(StageStyle.UTILITY);
        stage.initOwner(scene.getWindow());
        stage.setX(this.stage.getX() + this.stage.getWidth() + 10.0);
        stage.setY(this.stage.getY());
        stage.show();
    }

    public static void setAppLaunchedHandler(Consumer<Application> appLaunchedHandler) {
        HavenoApp.appLaunchedHandler = appLaunchedHandler;
    }

    public static Runnable getShutDownHandler() {
        return shutDownHandler;
    }

    public static void setOnGracefulShutDownHandler(Runnable onGracefulShutDownHandler) {
        HavenoApp.onGracefulShutDownHandler = onGracefulShutDownHandler;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public void setGracefulShutDownHandler(GracefulShutDownHandler gracefulShutDownHandler) {
        this.gracefulShutDownHandler = gracefulShutDownHandler;
    }
}

