/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.persistable.NavigationPath;
import haveno.common.proto.persistable.PersistableEnvelope;
import haveno.common.proto.persistable.PersistedDataHost;
import haveno.desktop.common.view.View;
import haveno.desktop.common.view.ViewPath;
import haveno.desktop.main.MainView;
import haveno.desktop.main.market.MarketView;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class Navigation
implements PersistedDataHost {
    private static final Logger log = LoggerFactory.getLogger(Navigation.class);
    private static final ViewPath DEFAULT_VIEW_PATH = ViewPath.to(MainView.class, MarketView.class);
    private final CopyOnWriteArraySet<Listener> listeners = new CopyOnWriteArraySet();
    private final PersistenceManager<NavigationPath> persistenceManager;
    private ViewPath currentPath;
    private ViewPath returnPath;
    private final NavigationPath navigationPath = new NavigationPath();
    private ViewPath previousPath = DEFAULT_VIEW_PATH;

    @Inject
    public Navigation(PersistenceManager<NavigationPath> persistenceManager) {
        this.persistenceManager = persistenceManager;
        persistenceManager.initialize((PersistableEnvelope)this.navigationPath, PersistenceManager.Source.PRIVATE_LOW_PRIO);
    }

    public void readPersisted(Runnable completeHandler) {
        this.persistenceManager.readPersisted(persisted -> {
            List viewClasses = persisted.getPath().stream().map(className -> {
                try {
                    return Class.forName(className).asSubclass(View.class);
                }
                catch (ClassNotFoundException e) {
                    log.warn("Could not find the viewPath class {}; exception: {}", className, (Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (!viewClasses.isEmpty()) {
                this.previousPath = new ViewPath(viewClasses);
            }
            completeHandler.run();
        }, completeHandler);
    }

    @SafeVarargs
    public final void navigateTo(Class<? extends View> ... viewClasses) {
        this.navigateTo(ViewPath.to(viewClasses), null);
    }

    @SafeVarargs
    public final void navigateToWithData(Object data, Class<? extends View> ... viewClasses) {
        this.navigateTo(ViewPath.to(viewClasses), data);
    }

    public void navigateTo(ViewPath newPath, @Nullable Object data) {
        if (newPath == null) {
            return;
        }
        ArrayList<Class> temp = new ArrayList<Class>();
        for (int i = 0; i < newPath.size(); ++i) {
            Class viewClass = (Class)newPath.get(i);
            temp.add(viewClass);
            if (this.currentPath != null && (this.currentPath.size() <= i || viewClass == this.currentPath.get(i) || i == newPath.size() - 1)) continue;
            ArrayList<Class> temp2 = new ArrayList<Class>(temp);
            for (int n = i + 1; n < newPath.size(); ++n) {
                Class[] newTemp = new Class[i + 1];
                this.currentPath = ViewPath.to(temp2.toArray(newTemp));
                this.navigateTo(this.currentPath, data);
                viewClass = (Class)newPath.get(n);
                temp2.add(viewClass);
            }
        }
        this.previousPath = this.currentPath = newPath;
        this.listeners.forEach(e -> e.onNavigationRequested(this.currentPath, data));
        this.requestPersistence();
    }

    private void requestPersistence() {
        if (this.currentPath.tip() != null) {
            this.navigationPath.setPath(this.currentPath.stream().map(Class::getName).collect(Collectors.toUnmodifiableList()));
        }
        this.persistenceManager.requestPersistence();
    }

    public void navigateToPreviousVisitedView() {
        if (this.previousPath == null || this.previousPath.size() == 0) {
            this.previousPath = DEFAULT_VIEW_PATH;
        }
        this.navigateTo(this.previousPath, null);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public ViewPath getReturnPath() {
        return this.returnPath;
    }

    public ViewPath getCurrentPath() {
        return this.currentPath;
    }

    public void setReturnPath(ViewPath returnPath) {
        this.returnPath = returnPath;
    }

    public ViewPath getPreviousPath() {
        return this.previousPath;
    }

    public void setPreviousPath(ViewPath previousPath) {
        this.previousPath = previousPath;
    }

    public static interface Listener {
        public void onNavigationRequested(ViewPath var1, @Nullable Object var2);
    }
}

