/*
 * Decompiled with CFR 0.152.
 */
package haveno.relay;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.FirebaseMessagingException;
import com.google.firebase.messaging.Message;
import com.google.firebase.messaging.Notification;
import com.turo.pushy.apns.ApnsClient;
import com.turo.pushy.apns.ApnsClientBuilder;
import com.turo.pushy.apns.ApnsPushNotification;
import com.turo.pushy.apns.PushNotificationResponse;
import com.turo.pushy.apns.util.ApnsPayloadBuilder;
import com.turo.pushy.apns.util.SimpleApnsPushNotification;
import com.turo.pushy.apns.util.concurrent.PushNotificationFuture;
import haveno.relay.RelayMain;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RelayService {
    private static final Logger log = LoggerFactory.getLogger(RelayMain.class);
    private static final String ANDROID_DATABASE_URL = "https://havenonotifications.firebaseio.com";
    private static final String SUCCESS = "success";
    private final String appleBundleId;
    private ApnsClient productionApnsClient;
    private ApnsClient devApnsClient;

    RelayService(String appleCertPwPath, String appleCertPath, String appleBundleId, String androidCertPath) {
        this.appleBundleId = appleBundleId;
        this.setupForAndroid(androidCertPath);
        this.setupForApple(appleCertPwPath, appleCertPath);
    }

    private void setupForAndroid(String androidCertPath) {
        try {
            FileInputStream androidCertStream = new FileInputStream(androidCertPath);
            FirebaseOptions options = new FirebaseOptions.Builder().setCredentials(GoogleCredentials.fromStream((InputStream)androidCertStream)).setDatabaseUrl(ANDROID_DATABASE_URL).build();
            FirebaseApp.initializeApp((FirebaseOptions)options);
        }
        catch (IOException e) {
            log.error(e.toString());
            e.printStackTrace();
        }
    }

    private void setupForApple(String appleCertPwPath, String appleCertPath) {
        try {
            FileInputStream certInputStream = new FileInputStream(appleCertPwPath);
            Scanner scanner = new Scanner(certInputStream);
            String password = scanner.next();
            this.productionApnsClient = new ApnsClientBuilder().setApnsServer("api.push.apple.com").setClientCredentials(new File(appleCertPath), password).build();
            this.devApnsClient = new ApnsClientBuilder().setApnsServer("api.development.push.apple.com").setClientCredentials(new File(appleCertPath), password).build();
        }
        catch (IOException e) {
            log.error(e.toString());
            e.printStackTrace();
        }
    }

    String sendAppleMessage(boolean isProduction, boolean isContentAvailable, String apsTokenHex, String encryptedMessage, boolean useSound) {
        ApnsPayloadBuilder payloadBuilder = new ApnsPayloadBuilder();
        if (useSound) {
            payloadBuilder.setSoundFileName("default");
        }
        payloadBuilder.setAlertBody("Haveno notification");
        payloadBuilder.setContentAvailable(isContentAvailable);
        payloadBuilder.addCustomProperty("encrypted", (Object)encryptedMessage);
        String payload = payloadBuilder.buildWithDefaultMaximumLength();
        log.info("payload " + payload);
        SimpleApnsPushNotification simpleApnsPushNotification = new SimpleApnsPushNotification(apsTokenHex, this.appleBundleId, payload);
        ApnsClient apnsClient = isProduction ? this.productionApnsClient : this.devApnsClient;
        PushNotificationFuture notificationFuture = apnsClient.sendNotification((ApnsPushNotification)simpleApnsPushNotification);
        try {
            PushNotificationResponse pushNotificationResponse = (PushNotificationResponse)notificationFuture.get();
            if (pushNotificationResponse.isAccepted()) {
                log.info("Push notification accepted by APNs gateway.");
                return SUCCESS;
            }
            String msg1 = "Notification rejected by the APNs gateway: " + pushNotificationResponse.getRejectionReason();
            Object msg2 = "";
            if (pushNotificationResponse.getTokenInvalidationTimestamp() != null) {
                msg2 = " and the token is invalid as of " + String.valueOf(pushNotificationResponse.getTokenInvalidationTimestamp());
            }
            log.info(msg1 + (String)msg2);
            return "Error: " + msg1 + (String)msg2;
        }
        catch (InterruptedException | ExecutionException e) {
            log.error(e.toString());
            e.printStackTrace();
            return "Error: " + e.toString();
        }
    }

    String sendAndroidMessage(String apsTokenHex, String encryptedMessage, boolean useSound) {
        Message.Builder messageBuilder = Message.builder();
        Notification notification = new Notification("Haveno", "Notification");
        messageBuilder.setNotification(notification);
        messageBuilder.putData("encrypted", encryptedMessage);
        messageBuilder.setToken(apsTokenHex);
        if (useSound) {
            messageBuilder.putData("sound", "default");
        }
        Message message = messageBuilder.build();
        try {
            FirebaseMessaging firebaseMessaging = FirebaseMessaging.getInstance();
            firebaseMessaging.send(message);
            return SUCCESS;
        }
        catch (FirebaseMessagingException e) {
            log.error(e.toString());
            e.printStackTrace();
            return "Error: " + e.toString();
        }
    }
}

