/*
 * Decompiled with CFR 0.152.
 */
package haveno.relay;

import ch.qos.logback.classic.Level;
import haveno.common.app.Log;
import haveno.common.util.Utilities;
import haveno.relay.RelayService;
import java.io.File;
import java.util.Locale;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Spark;

public class RelayMain {
    private static final Logger log = LoggerFactory.getLogger(RelayMain.class);
    private static final String VERSION = "0.1.0";
    private static RelayService relayService;

    public static void main(String[] args) {
        String logPath = System.getProperty("user.home") + File.separator + "provider";
        Log.setup((String)logPath);
        Log.setLevel((Level)Level.INFO);
        log.info("Log files under: " + logPath);
        log.info("RelayVersion.VERSION: 0.1.0");
        Utilities.printSysInfo();
        if (args.length <= 0) {
            throw new RuntimeException("You need to set the path to the password text file for the Apple push certificate as first argument.");
        }
        String appleCertPwPath = args[0];
        if (args.length <= 1) {
            throw new RuntimeException("You need to set the path to the Apple push certificate as second argument.");
        }
        String appleCertPath = args[1];
        if (args.length <= 2) {
            throw new RuntimeException("You need to set the Apple bundle ID as third argument.");
        }
        String appleBundleId = args[2];
        if (args.length <= 3) {
            throw new RuntimeException("You need to set the Android certificate path as 4th argument.");
        }
        String androidCertPath = args[3];
        int port = 8080;
        if (args.length > 4) {
            port = Integer.parseInt(args[4]);
        }
        Spark.port((int)port);
        relayService = new RelayService(appleCertPwPath, appleCertPath, appleBundleId, androidCertPath);
        RelayMain.handleRelay();
        RelayMain.keepRunning();
    }

    private static void handleRelay() {
        Spark.get((String)"/relay", (request, response) -> {
            log.info("Incoming relay request from: " + request.userAgent());
            boolean isAndroid = request.queryParams("isAndroid").equalsIgnoreCase("true");
            boolean useSound = request.queryParams("snd").equalsIgnoreCase("true");
            String token = new String(Hex.decodeHex((char[])request.queryParams("token").toCharArray()), "UTF-8");
            String encryptedMessage = new String(Hex.decodeHex((char[])request.queryParams("msg").toCharArray()), "UTF-8");
            log.info("isAndroid={}\nuseSound={}\napsTokenHex={}\nencryptedMessage={}", new Object[]{isAndroid, useSound, token, encryptedMessage});
            if (isAndroid) {
                return relayService.sendAndroidMessage(token, encryptedMessage, useSound);
            }
            boolean isProduction = request.queryParams("isProduction").equalsIgnoreCase("true");
            boolean isContentAvailable = request.queryParams("isContentAvailable").equalsIgnoreCase("true");
            return relayService.sendAppleMessage(isProduction, isContentAvailable, token, encryptedMessage, useSound);
        });
    }

    private static void keepRunning() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(Long.MAX_VALUE);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    static {
        Locale.setDefault(new Locale("en", Locale.getDefault().getCountry()));
    }
}

