/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.utils;

public class Base32 {
    private static final String BASE32_CHARS = "abcdefghijklmnopqrstuvwxyz234567";

    public static String base32Encode(byte[] source) {
        return Base32.base32Encode(source, 0, source.length);
    }

    public static String base32Encode(byte[] source, int offset, int length) {
        int nbits = length * 8;
        if (nbits % 5 != 0) {
            throw new IllegalArgumentException("Base32 input length must be a multiple of 5 bits");
        }
        int outlen = nbits / 5;
        StringBuffer outbuffer = new StringBuffer();
        int bit = 0;
        for (int i = 0; i < outlen; ++i) {
            int v = (source[bit / 8] & 0xFF) << 8;
            if (bit + 5 < nbits) {
                v += source[bit / 8 + 1] & 0xFF;
            }
            int u = v >> 11 - bit % 8 & 0x1F;
            outbuffer.append(BASE32_CHARS.charAt(u));
            bit += 5;
        }
        return outbuffer.toString();
    }

    public static byte[] base32Decode(String source) {
        int[] v = Base32.stringToIntVector(source);
        int nbits = source.length() * 5;
        if (nbits % 8 != 0) {
            throw new IllegalArgumentException("Base32 decoded array must be a muliple of 8 bits");
        }
        int outlen = nbits / 8;
        byte[] outbytes = new byte[outlen];
        int bit = 0;
        for (int i = 0; i < outlen; ++i) {
            int bb = bit / 5;
            outbytes[i] = (byte)Base32.decodeByte(bit, v[bb], v[bb + 1], v[bb + 2]);
            bit += 8;
        }
        return outbytes;
    }

    private static int decodeByte(int bitOffset, int b0, int b1, int b2) {
        switch (bitOffset % 40) {
            case 0: {
                return Base32.ls(b0, 3) + Base32.rs(b1, 2);
            }
            case 8: {
                return Base32.ls(b0, 6) + Base32.ls(b1, 1) + Base32.rs(b2, 4);
            }
            case 16: {
                return Base32.ls(b0, 4) + Base32.rs(b1, 1);
            }
            case 24: {
                return Base32.ls(b0, 7) + Base32.ls(b1, 2) + Base32.rs(b2, 3);
            }
            case 32: {
                return Base32.ls(b0, 5) + (b1 & 0xFF);
            }
        }
        throw new IllegalArgumentException("Illegal bit offset");
    }

    private static int ls(int n, int shift) {
        return n << shift & 0xFF;
    }

    private static int rs(int n, int shift) {
        return n >> shift & 0xFF;
    }

    private static int[] stringToIntVector(String s) {
        int[] ints = new int[s.length() + 1];
        for (int i = 0; i < s.length(); ++i) {
            int b = s.charAt(i) & 0xFF;
            if (b > 96 && b < 123) {
                ints[i] = b - 97;
                continue;
            }
            if (b > 49 && b < 56) {
                ints[i] = b - 24;
                continue;
            }
            if (b > 64 && b < 91) {
                ints[i] = b - 65;
                continue;
            }
            throw new IllegalArgumentException("Illegal character in base32 encoded string: " + s.charAt(i));
        }
        return ints;
    }
}

