/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.channels;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import javax.annotation.Nullable;
import org.bitcoin.paymentchannel.Protos;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.protocols.channels.PaymentChannelClient;
import org.bitcoinj.protocols.channels.PaymentChannelCloseException;
import org.bitcoinj.protocols.channels.PaymentIncrementAck;
import org.bitcoinj.protocols.channels.ValueOutOfRangeException;
import org.bitcoinj.wallet.SendRequest;
import org.bouncycastle.crypto.params.KeyParameter;

public interface IPaymentChannelClient {
    public void receiveMessage(Protos.TwoWayChannelMessage var1) throws InsufficientMoneyException;

    public void connectionClosed();

    public void settle() throws IllegalStateException;

    public void connectionOpen();

    public ListenableFuture<PaymentIncrementAck> incrementPayment(Coin var1, @Nullable ByteString var2, @Nullable KeyParameter var3) throws ValueOutOfRangeException, IllegalStateException, ECKey.KeyIsEncryptedException;

    public static interface Factory {
        public IPaymentChannelClient create(String var1, ClientConnection var2);
    }

    public static interface ClientChannelProperties {
        public SendRequest modifyContractSendRequest(SendRequest var1);

        public Coin acceptableMinPayment();

        public long timeWindow();

        public PaymentChannelClient.VersionSelector versionSelector();
    }

    public static interface ClientConnection {
        public void sendToServer(Protos.TwoWayChannelMessage var1);

        public void destroyConnection(PaymentChannelCloseException.CloseReason var1);

        public boolean acceptExpireTime(long var1);

        public void channelOpen(boolean var1);
    }
}

