/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.params;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.math.BigInteger;
import java.util.concurrent.TimeUnit;
import org.bitcoinj.core.BitcoinSerializer;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.utils.MonetaryFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBitcoinNetParams
extends NetworkParameters {
    public static final String BITCOIN_SCHEME = "bitcoin";
    public static final int REWARD_HALVING_INTERVAL = 210000;
    private static final Logger log = LoggerFactory.getLogger(AbstractBitcoinNetParams.class);

    public final boolean isRewardHalvingPoint(int height) {
        return (height + 1) % 210000 == 0;
    }

    public final boolean isDifficultyTransitionPoint(int height) {
        return (height + 1) % this.getInterval() == 0;
    }

    @Override
    public void checkDifficultyTransitions(StoredBlock storedPrev, Block nextBlock, BlockStore blockStore) throws VerificationException, BlockStoreException {
        int targetTimespan;
        Block prev = storedPrev.getHeader();
        if (!this.isDifficultyTransitionPoint(storedPrev.getHeight())) {
            if (nextBlock.getDifficultyTarget() != prev.getDifficultyTarget()) {
                throw new VerificationException("Unexpected change in difficulty at height " + storedPrev.getHeight() + ": " + Long.toHexString(nextBlock.getDifficultyTarget()) + " vs " + Long.toHexString(prev.getDifficultyTarget()));
            }
            return;
        }
        Stopwatch watch = Stopwatch.createStarted();
        Sha256Hash hash = prev.getHash();
        StoredBlock cursor = null;
        int interval = this.getInterval();
        for (int i = 0; i < interval; ++i) {
            cursor = blockStore.get(hash);
            if (cursor == null) {
                throw new VerificationException("Difficulty transition point but we did not find a way back to the last transition point. Not found: " + hash);
            }
            hash = cursor.getHeader().getPrevBlockHash();
        }
        Preconditions.checkState((cursor != null && this.isDifficultyTransitionPoint(cursor.getHeight() - 1) ? 1 : 0) != 0, (Object)"Didn't arrive at a transition point.");
        watch.stop();
        if (watch.elapsed(TimeUnit.MILLISECONDS) > 50L) {
            log.info("Difficulty transition traversal took {}", (Object)watch);
        }
        Block blockIntervalAgo = cursor.getHeader();
        int timespan = (int)(prev.getTimeSeconds() - blockIntervalAgo.getTimeSeconds());
        if (timespan < (targetTimespan = this.getTargetTimespan()) / 4) {
            timespan = targetTimespan / 4;
        }
        if (timespan > targetTimespan * 4) {
            timespan = targetTimespan * 4;
        }
        BigInteger newTarget = Utils.decodeCompactBits(prev.getDifficultyTarget());
        newTarget = newTarget.multiply(BigInteger.valueOf(timespan));
        if ((newTarget = newTarget.divide(BigInteger.valueOf(targetTimespan))).compareTo(this.getMaxTarget()) > 0) {
            log.info("Difficulty hit proof of work limit: {}", (Object)newTarget.toString(16));
            newTarget = this.getMaxTarget();
        }
        int accuracyBytes = (int)(nextBlock.getDifficultyTarget() >>> 24) - 3;
        long receivedTargetCompact = nextBlock.getDifficultyTarget();
        BigInteger mask = BigInteger.valueOf(0xFFFFFFL).shiftLeft(accuracyBytes * 8);
        long newTargetCompact = Utils.encodeCompactBits(newTarget = newTarget.and(mask));
        if (newTargetCompact != receivedTargetCompact) {
            throw new VerificationException("Network provided difficulty bits do not match what was calculated: " + Long.toHexString(newTargetCompact) + " vs " + Long.toHexString(receivedTargetCompact));
        }
    }

    @Override
    public Coin getMaxMoney() {
        return MAX_MONEY;
    }

    @Override
    public Coin getMinNonDustOutput() {
        return Transaction.MIN_NONDUST_OUTPUT;
    }

    @Override
    public MonetaryFormat getMonetaryFormat() {
        return MonetaryFormat.BTC;
    }

    @Override
    public int getProtocolVersionNum(NetworkParameters.ProtocolVersion version) {
        return version.getBitcoinProtocolVersion();
    }

    @Override
    public BitcoinSerializer getSerializer(boolean parseRetain) {
        return new BitcoinSerializer(this, parseRetain);
    }

    @Override
    public String getUriScheme() {
        return BITCOIN_SCHEME;
    }

    @Override
    public boolean hasMaxMoney() {
        return true;
    }
}

