/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.bitcoinj.core.Utils;
import org.bitcoinj.utils.Base32;

public class OnionCatConverter {
    public static byte[] onionHostToIPV6Bytes(String hostname) {
        String needle = ".onion";
        if (hostname.endsWith(needle)) {
            if (hostname.length() != 22) {
                throw new IllegalArgumentException("Invalid hostname: " + hostname);
            }
            hostname = hostname.substring(0, hostname.length() - needle.length());
        } else if (hostname.length() != 16) {
            throw new IllegalArgumentException("Invalid hostname: " + hostname);
        }
        byte[] prefix = new byte[]{-3, -121, -40, 126, -21, 67};
        byte[] onionaddr = Base32.base32Decode(hostname);
        byte[] ipBytes = new byte[prefix.length + onionaddr.length];
        System.arraycopy(prefix, 0, ipBytes, 0, prefix.length);
        System.arraycopy(onionaddr, 0, ipBytes, prefix.length, onionaddr.length);
        return ipBytes;
    }

    public static InetAddress onionHostToInetAddress(String hostname) throws UnknownHostException {
        return InetAddress.getByAddress(OnionCatConverter.onionHostToIPV6Bytes(hostname));
    }

    public static String IPV6BytesToOnionHost(byte[] bytes) {
        if (bytes.length != 16) {
            throw new IllegalArgumentException("Invalid IPv6 address: " + Utils.HEX.encode(bytes));
        }
        String base32 = Base32.base32Encode(Arrays.copyOfRange(bytes, 6, 16));
        return base32.toLowerCase() + ".onion";
    }
}

