/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Set;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import org.bitcoinj.core.Context;
import org.bitcoinj.net.MessageWriteTarget;
import org.bitcoinj.net.StreamConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingClient
implements MessageWriteTarget {
    private static final Logger log = LoggerFactory.getLogger(BlockingClient.class);
    private static final int BUFFER_SIZE_LOWER_BOUND = 4096;
    private static final int BUFFER_SIZE_UPPER_BOUND = 65536;
    private Socket socket;
    private volatile boolean vCloseRequested = false;
    private SettableFuture<SocketAddress> connectFuture = SettableFuture.create();

    public BlockingClient(final SocketAddress serverAddress, final StreamConnection connection, final int connectTimeoutMillis, SocketFactory socketFactory, final @Nullable Set<BlockingClient> clientSet) throws IOException {
        connection.setWriteTarget(this);
        this.socket = socketFactory.createSocket();
        final Context context = Context.get();
        Thread t = new Thread(){

            @Override
            public void run() {
                Context.propagate(context);
                if (clientSet != null) {
                    clientSet.add(BlockingClient.this);
                }
                try {
                    BlockingClient.this.socket.connect(serverAddress, connectTimeoutMillis);
                    connection.connectionOpened();
                    BlockingClient.this.connectFuture.set((Object)serverAddress);
                    InputStream stream = BlockingClient.this.socket.getInputStream();
                    BlockingClient.runReadLoop(stream, connection);
                }
                catch (Exception e) {
                    if (!BlockingClient.this.vCloseRequested) {
                        log.error("Error trying to open/read from connection: {}: {}", (Object)serverAddress, (Object)e.getMessage());
                        BlockingClient.this.connectFuture.setException((Throwable)e);
                    }
                }
                finally {
                    try {
                        BlockingClient.this.socket.close();
                    }
                    catch (IOException iOException) {}
                    if (clientSet != null) {
                        clientSet.remove(BlockingClient.this);
                    }
                    connection.connectionClosed();
                }
            }
        };
        t.setName("BlockingClient network thread for " + serverAddress);
        t.setDaemon(true);
        t.start();
    }

    public static void runReadLoop(InputStream stream, StreamConnection connection) throws Exception {
        ByteBuffer dbuf = ByteBuffer.allocateDirect(Math.min(Math.max(connection.getMaxMessageSize(), 4096), 65536));
        byte[] readBuff = new byte[dbuf.capacity()];
        while (true) {
            Preconditions.checkState((dbuf.remaining() > 0 && dbuf.remaining() <= readBuff.length ? 1 : 0) != 0);
            int read = stream.read(readBuff, 0, Math.max(1, Math.min(dbuf.remaining(), stream.available())));
            if (read == -1) {
                return;
            }
            dbuf.put(readBuff, 0, read);
            dbuf.flip();
            int bytesConsumed = connection.receiveBytes(dbuf);
            Preconditions.checkState((dbuf.position() == bytesConsumed ? 1 : 0) != 0);
            dbuf.compact();
        }
    }

    @Override
    public void closeConnection() {
        try {
            this.vCloseRequested = true;
            this.socket.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized ListenableFuture writeBytes(byte[] message) throws IOException {
        try {
            if (!this.socket.isClosed()) {
                OutputStream stream = this.socket.getOutputStream();
                stream.write(message);
                stream.flush();
            } else {
                log.warn("Attempted to write to a closed socket.");
            }
            return Futures.immediateFuture(null);
        }
        catch (IOException e) {
            log.error("Error writing message to connection, closing connection", (Throwable)e);
            this.closeConnection();
            throw e;
        }
    }

    public ListenableFuture<SocketAddress> getConnectFuture() {
        return this.connectFuture;
    }
}

