/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Utils;

public final class BlockLocator {
    private final ImmutableList<Sha256Hash> hashes;

    public BlockLocator() {
        this.hashes = ImmutableList.of();
    }

    public BlockLocator(ImmutableList<Sha256Hash> hashes) {
        this.hashes = hashes;
    }

    public BlockLocator add(Sha256Hash hash) {
        return new BlockLocator((ImmutableList<Sha256Hash>)new ImmutableList.Builder().addAll(this.hashes).add((Object)hash).build());
    }

    public int size() {
        return this.hashes.size();
    }

    public List<Sha256Hash> getHashes() {
        return this.hashes;
    }

    public Sha256Hash get(int i) {
        return (Sha256Hash)this.hashes.get(i);
    }

    public String toString() {
        return "Block locator with " + this.size() + " blocks\n " + Utils.SPACE_JOINER.join(this.hashes);
    }

    public int hashCode() {
        int hashCode = 0;
        for (Sha256Hash i : this.hashes) {
            hashCode ^= i.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return ((BlockLocator)o).getHashes().equals(this.hashes);
    }
}

